/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.swagger.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.daijie.core.swagger.web.ZuulSwaggerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import springfox.documentation.spring.web.PropertySourcedMapping;
import springfox.documentation.swagger.web.SwaggerResource;

@RestController
public class FocusSwaggerController {
    protected Logger logger = LoggerFactory.getLogger(FocusSwaggerController.class);
    public static final String SWAGGER_RESOURCES_URL = "/swagger-resources";
    public static final String SWAGGER_RESOURCES_UI_URL = "/swagger-resources/configuration/ui";
    public static final String DEFAULT_URL = "/focus/api-docs";
    public static final String RESOURCES_URL = "/focus-resources";
    public static final String PARAM = "?group=";
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    private static final String SPLIT = ".";
    private final RestTemplate restTemplate;
    private final ZuulSwaggerProperties zuulSwaggerProperties;

    @Autowired
    public FocusSwaggerController(RestTemplate restTemplate, ZuulSwaggerProperties zuulSwaggerProperties) {
        this.restTemplate = restTemplate;
        this.zuulSwaggerProperties = zuulSwaggerProperties;
    }

    @RequestMapping(value={"/focus/api-docs"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @PropertySourcedMapping(value="${springfox.documentation.swagger.v2.path}", propertyKey="springfox.documentation.swagger.v2.path")
    public Object getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
        if (!swaggerGroup.contains(SPLIT)) {
            return null;
        }
        String[] split = swaggerGroup.split("\\.");
        Map documentation = null;
        try {
            int request = 0;
            while (request < 3) {
                try {
                    documentation = (Map)this.restTemplate.getForObject("http://" + split[0] + "/v2/api-docs" + PARAM + split[1], Map.class, new Object[0]);
                    request = 3;
                }
                catch (Exception e) {
                    ++request;
                }
            }
            if (!this.zuulSwaggerProperties.getRoutes().isEmpty()) {
                for (Map.Entry<String, ZuulSwaggerProperties.ZuulRoute> next : this.zuulSwaggerProperties.getRoutes().entrySet()) {
                    if (!split[0].equals(next.getValue().getServiceId())) continue;
                    documentation.put("basePath", "/" + next.getKey());
                    documentation.put("host", servletRequest.getServerName() + ":" + servletRequest.getServerPort());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("API\u670d\u52a1\u540d{}\u52a0\u8f7d\u6587\u6863\u5931\u8d25\uff01", (Object)swaggerGroup);
            this.logger.error("", (Throwable)e);
        }
        return documentation;
    }

    @RequestMapping(value={"/focus-resources"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    public Object swaggerResources() {
        Iterator<Map.Entry<String, ZuulSwaggerProperties.ZuulRoute>> iterator = this.zuulSwaggerProperties.getRoutes().entrySet().iterator();
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            Map.Entry<String, ZuulSwaggerProperties.ZuulRoute> next = iterator.next();
            try {
                Iterable datas = null;
                this.swaggerResourcesUI(next.getValue().getServiceId());
                int request = 0;
                while (request < 3) {
                    try {
                        datas = (List)this.restTemplate.getForObject("http://" + next.getValue().getServiceId() + SWAGGER_RESOURCES_URL, List.class, new Object[0]);
                        request = 3;
                    }
                    catch (Exception e) {
                        ++request;
                    }
                }
                if (datas == null) continue;
                datas.forEach(data -> {
                    SwaggerResource swaggerResource = new SwaggerResource();
                    swaggerResource.setLocation(((String)data.get("location")).replace(PARAM, PARAM + ((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceId() + SPLIT));
                    swaggerResource.setUrl(((String)data.get("url")).replace(PARAM, PARAM + ((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceId() + SPLIT));
                    swaggerResource.setSwaggerVersion((String)data.get("swaggerVersion"));
                    swaggerResource.setName(((ZuulSwaggerProperties.ZuulRoute)next.getValue()).getServiceId() + SPLIT + (String)data.get("name"));
                    list.add(swaggerResource);
                });
            }
            catch (Exception e) {
                this.logger.error("API\u670d\u52a1\u540d{}\u52a0\u8f7d\u8d44\u6e90\u5931\u8d25\uff01", (Object)next.getValue().getServiceId());
                this.logger.error("", (Throwable)e);
                return list;
            }
        }
        return list;
    }

    public Object swaggerResourcesUI(String serviceId) {
        return this.restTemplate.getForObject("http://" + serviceId + SWAGGER_RESOURCES_UI_URL, Object.class, new Object[0]);
    }
}

