/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.swagger;

import java.util.List;
import java.util.NoSuchElementException;
import org.daijie.core.swagger.ApiInfoDocketFactory;
import org.daijie.core.swagger.SwaggerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class SwaggerConfiguration
extends ApiInfoDocketFactory
implements EnvironmentAware {
    protected Logger logger = LoggerFactory.getLogger(SwaggerConfiguration.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void docket(List<SwaggerProperties> properties, BeanDefinitionRegistry registry) {
        String[] groupNames = StringUtils.tokenizeToStringArray((String)this.environment.getProperty("swagger.groupNames"), (String)",; \t\n");
        if (groupNames == null || groupNames.length == 0) {
            try {
                SwaggerProperties swaggerProperties = (SwaggerProperties)Binder.get((Environment)this.environment).bind("swagger", SwaggerProperties.class).get();
                swaggerProperties.setGroupName("swaggerDocment");
                properties.add(swaggerProperties);
            }
            catch (NoSuchElementException e) {
                this.logger.debug("\u6ca1\u6709\u8bfb\u53d6\u5230\u914d\u7f6eswagger\u5c5e\u6027\uff0c\u4f7f\u7528swagger\u5b98\u65b9\u9ed8\u8ba4\u914d\u7f6e\uff01");
            }
        } else {
            for (String groupName : groupNames) {
                try {
                    SwaggerProperties swaggerProperties = (SwaggerProperties)Binder.get((Environment)this.environment).bind("swagger." + groupName, SwaggerProperties.class).get();
                    swaggerProperties.setGroupName(groupName);
                    properties.add(swaggerProperties);
                }
                catch (NoSuchElementException e) {
                    this.logger.error("\u6ca1\u6709\u8bfb\u53d6\u5230\u7ec4<{}>\u914d\u7f6eswagger\u5c5e\u6027\uff01", (Object)groupName, (Object)e);
                    throw e;
                }
            }
        }
    }
}

