/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.swagger;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.daijie.core.swagger.RewriteApiSelectorBuilder;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.PathProvider;
import springfox.documentation.annotations.Incubating;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRules;
import springfox.documentation.schema.CodeGenGenericTypeNamingStrategy;
import springfox.documentation.schema.DefaultGenericTypeNamingStrategy;
import springfox.documentation.schema.WildcardType;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.Tag;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.service.DocumentationPlugin;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.DocumentationContextBuilder;
import springfox.documentation.spi.service.contexts.SecurityContext;

public class RewriteDocket
implements DocumentationPlugin {
    public static final String DEFAULT_GROUP_NAME = "default";
    private final DocumentationType documentationType;
    private final List<SecurityContext> securityContexts = Lists.newArrayList();
    private final Map<RequestMethod, List<ResponseMessage>> responseMessages = Maps.newHashMap();
    private final List<Parameter> globalOperationParameters = Lists.newArrayList();
    private final List<Function<TypeResolver, AlternateTypeRule>> ruleBuilders = Lists.newArrayList();
    private final Set<Class> ignorableParameterTypes = Sets.newHashSet();
    private final Set<String> protocols = Sets.newHashSet();
    private final Set<String> produces = Sets.newHashSet();
    private final Set<String> consumes = Sets.newHashSet();
    private final Set<ResolvedType> additionalModels = Sets.newHashSet();
    private final Set<Tag> tags = Sets.newHashSet();
    private PathProvider pathProvider;
    private List<? extends SecurityScheme> securitySchemes;
    private Ordering<ApiListingReference> apiListingReferenceOrdering;
    private Ordering<ApiDescription> apiDescriptionOrdering;
    private Ordering<Operation> operationOrdering;
    private ApiInfo apiInfo = ApiInfo.DEFAULT;
    private String groupName = "default";
    private boolean enabled = true;
    private GenericTypeNamingStrategy genericsNamingStrategy = new DefaultGenericTypeNamingStrategy();
    private boolean applyDefaultResponseMessages = true;
    private String host = "";
    private Optional<String> pathMapping = Optional.absent();
    private ApiSelector apiSelector = ApiSelector.DEFAULT;
    private boolean enableUrlTemplating = false;
    private List<VendorExtension> vendorExtensions = Lists.newArrayList();

    public RewriteDocket(DocumentationType documentationType) {
        this.documentationType = documentationType;
    }

    public RewriteDocket extensions(List<VendorExtension> vendorExtensions) {
        this.vendorExtensions.addAll(vendorExtensions);
        return this;
    }

    public RewriteDocket apiInfo(ApiInfo apiInfo) {
        this.apiInfo = (ApiInfo)BuilderDefaults.defaultIfAbsent((Object)apiInfo, (Object)apiInfo);
        return this;
    }

    public RewriteDocket securitySchemes(List<? extends SecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
        return this;
    }

    public RewriteDocket securityContexts(List<SecurityContext> securityContexts) {
        this.securityContexts.addAll(securityContexts);
        return this;
    }

    public RewriteDocket groupName(String groupName) {
        this.groupName = (String)BuilderDefaults.defaultIfAbsent((Object)groupName, (Object)this.groupName);
        return this;
    }

    public RewriteDocket pathProvider(PathProvider pathProvider) {
        this.pathProvider = pathProvider;
        return this;
    }

    public RewriteDocket globalResponseMessage(RequestMethod requestMethod, List<ResponseMessage> responseMessages) {
        this.responseMessages.put(requestMethod, responseMessages);
        return this;
    }

    public RewriteDocket globalOperationParameters(List<Parameter> operationParameters) {
        this.globalOperationParameters.addAll(BuilderDefaults.nullToEmptyList(operationParameters));
        return this;
    }

    public RewriteDocket ignoredParameterTypes(Class ... classes) {
        this.ignorableParameterTypes.addAll(Arrays.asList(classes));
        return this;
    }

    public RewriteDocket produces(Set<String> produces) {
        this.produces.addAll(produces);
        return this;
    }

    public RewriteDocket consumes(Set<String> consumes) {
        this.consumes.addAll(consumes);
        return this;
    }

    @Incubating(value="2.3")
    public RewriteDocket host(String host) {
        this.host = (String)BuilderDefaults.defaultIfAbsent((Object)host, (Object)this.host);
        return this;
    }

    public RewriteDocket protocols(Set<String> protocols) {
        this.protocols.addAll(protocols);
        return this;
    }

    public RewriteDocket alternateTypeRules(AlternateTypeRule ... alternateTypeRules) {
        this.ruleBuilders.addAll((Collection<Function<TypeResolver, AlternateTypeRule>>)FluentIterable.from((Iterable)Lists.newArrayList((Object[])alternateTypeRules)).transform(this.identityRuleBuilder()).toList());
        return this;
    }

    public RewriteDocket operationOrdering(Ordering<Operation> operationOrdering) {
        this.operationOrdering = operationOrdering;
        return this;
    }

    public RewriteDocket directModelSubstitute(Class clazz, Class with) {
        this.ruleBuilders.add(this.newSubstitutionFunction(clazz, with));
        return this;
    }

    public RewriteDocket genericModelSubstitutes(Class ... genericClasses) {
        for (Class clz : genericClasses) {
            this.ruleBuilders.add(this.newGenericSubstitutionFunction(clz));
        }
        return this;
    }

    public RewriteDocket useDefaultResponseMessages(boolean apply) {
        this.applyDefaultResponseMessages = apply;
        return this;
    }

    public RewriteDocket apiListingReferenceOrdering(Ordering<ApiListingReference> apiListingReferenceOrdering) {
        this.apiListingReferenceOrdering = apiListingReferenceOrdering;
        return this;
    }

    public RewriteDocket apiDescriptionOrdering(Ordering<ApiDescription> apiDescriptionOrdering) {
        this.apiDescriptionOrdering = apiDescriptionOrdering;
        return this;
    }

    public RewriteDocket enable(boolean externallyConfiguredFlag) {
        this.enabled = externallyConfiguredFlag;
        return this;
    }

    public RewriteDocket forCodeGeneration(boolean forCodeGen) {
        if (forCodeGen) {
            this.genericsNamingStrategy = new CodeGenGenericTypeNamingStrategy();
        }
        return this;
    }

    public RewriteDocket pathMapping(String path) {
        this.pathMapping = Optional.fromNullable((Object)path);
        return this;
    }

    @Incubating(value="2.1.0")
    public RewriteDocket enableUrlTemplating(boolean enabled) {
        this.enableUrlTemplating = enabled;
        return this;
    }

    public RewriteDocket additionalModels(ResolvedType first, ResolvedType ... remaining) {
        this.additionalModels.add(first);
        this.additionalModels.addAll(Sets.newHashSet((Object[])remaining));
        return this;
    }

    public RewriteDocket tags(Tag first, Tag ... remaining) {
        this.tags.add(first);
        this.tags.addAll(Sets.newHashSet((Object[])remaining));
        return this;
    }

    public RewriteApiSelectorBuilder select() {
        return new RewriteApiSelectorBuilder(this);
    }

    public DocumentationContext configure(DocumentationContextBuilder builder) {
        return builder.apiInfo(this.apiInfo).selector(this.apiSelector).applyDefaultResponseMessages(this.applyDefaultResponseMessages).additionalResponseMessages(this.responseMessages).additionalOperationParameters(this.globalOperationParameters).additionalIgnorableTypes(this.ignorableParameterTypes).ruleBuilders(this.ruleBuilders).groupName(this.groupName).pathProvider(this.pathProvider).securityContexts(this.securityContexts).securitySchemes(this.securitySchemes).apiListingReferenceOrdering(this.apiListingReferenceOrdering).apiDescriptionOrdering(this.apiDescriptionOrdering).operationOrdering(this.operationOrdering).produces(this.produces).consumes(this.consumes).host(this.host).protocols(this.protocols).genericsNaming(this.genericsNamingStrategy).pathMapping(this.pathMapping).enableUrlTemplating(this.enableUrlTemplating).additionalModels(this.additionalModels).tags(this.tags).vendorExtentions(this.vendorExtensions).build();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DocumentationType getDocumentationType() {
        return this.documentationType;
    }

    public boolean supports(DocumentationType delimiter) {
        return this.documentationType.equals((Object)delimiter);
    }

    private Function<AlternateTypeRule, Function<TypeResolver, AlternateTypeRule>> identityRuleBuilder() {
        return new Function<AlternateTypeRule, Function<TypeResolver, AlternateTypeRule>>(){

            public Function<TypeResolver, AlternateTypeRule> apply(AlternateTypeRule rule) {
                return RewriteDocket.this.identityFunction(rule);
            }
        };
    }

    private Function<TypeResolver, AlternateTypeRule> identityFunction(final AlternateTypeRule rule) {
        return new Function<TypeResolver, AlternateTypeRule>(){

            public AlternateTypeRule apply(TypeResolver typeResolver) {
                return rule;
            }
        };
    }

    RewriteDocket selector(ApiSelector apiSelector) {
        this.apiSelector = apiSelector;
        return this;
    }

    private Function<TypeResolver, AlternateTypeRule> newSubstitutionFunction(final Class clazz, final Class with) {
        return new Function<TypeResolver, AlternateTypeRule>(){

            public AlternateTypeRule apply(TypeResolver typeResolver) {
                return AlternateTypeRules.newRule((Type)typeResolver.resolve((Type)clazz, new Type[0]), (Type)typeResolver.resolve((Type)with, new Type[0]), (int)-2147480648);
            }
        };
    }

    private Function<TypeResolver, AlternateTypeRule> newGenericSubstitutionFunction(final Class clz) {
        return new Function<TypeResolver, AlternateTypeRule>(){

            public AlternateTypeRule apply(TypeResolver typeResolver) {
                return AlternateTypeRules.newRule((Type)typeResolver.resolve((Type)clz, new Type[]{WildcardType.class}), (Type)typeResolver.resolve(WildcardType.class, new Type[0]), (int)-2147481648);
            }
        };
    }
}

