/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.swagger;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.daijie.core.swagger.RewriteDocket;
import springfox.documentation.RequestHandler;
import springfox.documentation.spi.service.contexts.ApiSelector;

public class RewriteApiSelectorBuilder {
    private final RewriteDocket parent;
    private Predicate<RequestHandler> requestHandlerSelector = ApiSelector.DEFAULT.getRequestHandlerSelector();
    private Predicate<String> pathSelector = ApiSelector.DEFAULT.getPathSelector();

    public RewriteApiSelectorBuilder(RewriteDocket parent) {
        this.parent = parent;
    }

    public RewriteApiSelectorBuilder apis(Predicate<RequestHandler> selector) {
        this.requestHandlerSelector = Predicates.and(this.requestHandlerSelector, selector);
        return this;
    }

    public RewriteApiSelectorBuilder paths(Predicate<String> selector) {
        this.pathSelector = Predicates.and(this.pathSelector, selector);
        return this;
    }

    public RewriteDocket build() {
        return this.parent.selector(new ApiSelector(this.combine(this.requestHandlerSelector, this.pathSelector), this.pathSelector));
    }

    private Predicate<RequestHandler> combine(Predicate<RequestHandler> requestHandlerSelector, Predicate<String> pathSelector) {
        return Predicates.and(requestHandlerSelector, this.transform(pathSelector));
    }

    private Predicate<RequestHandler> transform(final Predicate<String> pathSelector) {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return Iterables.any((Iterable)input.getPatternsCondition().getPatterns(), (Predicate)pathSelector);
            }
        };
    }
}

