/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.result;

import java.io.Serializable;
import org.daijie.core.controller.enums.ResultCode;
import org.daijie.core.result.ModelResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelResultWrapper<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Logger logger = LoggerFactory.getLogger(ModelResultWrapper.class);
    private ModelResult<E> modelResult = new ModelResult();

    public ModelResultWrapper() {
    }

    public ModelResultWrapper(boolean success) {
        this.modelResult.setSuccess(success);
    }

    public ModelResultWrapper(boolean success, ResultCode code) {
        this.modelResult.setSuccess(success);
        this.modelResult.setCode(code.getValue());
        this.modelResult.setMsg(code.getDescription());
    }

    public ModelResultWrapper(boolean success, ResultCode code, String msg) {
        this.modelResult.setSuccess(success);
        this.modelResult.setCode(code.getValue());
        this.modelResult.setMsg(msg);
    }

    public ModelResultWrapper<E> setSuccess(boolean success) {
        this.modelResult.setSuccess(success);
        return this;
    }

    public ModelResultWrapper<E> setMsg(String msg) {
        this.modelResult.setMsg(msg);
        return this;
    }

    public ModelResultWrapper<E> setCode(ResultCode code) {
        this.modelResult.setCode(code.getValue());
        return this;
    }

    public ModelResultWrapper<E> setData(E value) {
        this.modelResult.setData(value);
        return this;
    }

    public ModelResult<E> build() {
        return this.modelResult;
    }
}

