/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.process;

import java.lang.reflect.Array;
import org.daijie.core.factory.IEnumFactory;
import org.daijie.core.process.Process;
import org.daijie.core.process.ProcessHandle;

public class OrderEnumProcess<E extends IEnumFactory<E>>
implements ProcessHandle<E> {
    private static final long serialVersionUID = -4355337954752651386L;
    private E[] elements;
    private int size;

    private void insert(E element) {
        E[] datas = this.elements;
        this.elements = (IEnumFactory[])Array.newInstance(element.getClass(), ++this.size);
        if (this.size > 1) {
            System.arraycopy(datas, 0, this.elements, 0, datas.length);
        }
        this.elements[this.size - 1] = element;
    }

    @Override
    public boolean add(E element) {
        this.insert(element);
        return true;
    }

    @Override
    public boolean add(E[] elements) {
        for (E element : elements) {
            this.insert(element);
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public E next(E element) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (!this.elements[i].equals(element)) continue;
            return this.elements[i + 1];
        }
        return null;
    }

    @Override
    public E next(E element, Process processEnum) {
        if (processEnum == Process.THROUGH) {
            return this.next(element);
        }
        return this.elements[this.elements.length - 1];
    }

    public E pre(E element) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (!this.elements[i].equals(element)) continue;
            return this.elements[i - 1];
        }
        return null;
    }

    @Override
    public E pre(E element, Process processEnum) {
        return this.pre(element);
    }
}

