/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock.zk;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.daijie.core.lock.DistributedLockTemplate;
import org.daijie.core.lock.zk.ZKLockProperties;
import org.daijie.core.lock.zk.ZkDistributedLockTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ZKLockProperties.class})
public class ZKLockAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CuratorFramework curatorFramework(ZKLockProperties lockZKProperties) {
        CuratorFramework CuratorFramework2 = CuratorFrameworkFactory.newClient((String)lockZKProperties.getAddresses(), (RetryPolicy)new ExponentialBackoffRetry(lockZKProperties.getBaseSleepTimeMs().intValue(), lockZKProperties.getMaxRetries().intValue()));
        return CuratorFramework2;
    }

    @Bean
    @ConditionalOnMissingBean
    public DistributedLockTemplate distributedLockTemplate(CuratorFramework curatorFramework) {
        curatorFramework.start();
        return new ZkDistributedLockTemplate(curatorFramework);
    }
}

