/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock.redis;

import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.daijie.core.lock.DistributedLockTemplate;
import org.daijie.core.lock.redis.RedisDistributedLockTemplate;
import org.daijie.core.lock.redis.RedisLockProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={RedisLockProperties.class})
public class RedisLockAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RedisLockAutoConfiguration.class);

    @Bean(name={"jedisLock"})
    public Object jedisLock(RedisLockProperties lockZKProperties) {
        try {
            if (lockZKProperties.getAddresses().contains(",")) {
                String[] serverArray = lockZKProperties.getAddresses().split(",");
                HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
                for (String ipPort : serverArray) {
                    String[] ipPortPair = ipPort.split(":");
                    nodes.add(new HostAndPort(ipPortPair[0].trim(), Integer.valueOf(ipPortPair[1].trim()).intValue()));
                }
                return new JedisCluster(nodes, 2000, 2000, 1, lockZKProperties.getPassword(), new GenericObjectPoolConfig());
            }
            JedisPool jedisPool = null;
            String[] local = lockZKProperties.getAddresses().split(":");
            jedisPool = StringUtils.isEmpty((Object)lockZKProperties.getPassword()) ? new JedisPool(local[0].trim(), Integer.parseInt(local[1].trim())) : new JedisPool(new GenericObjectPoolConfig(), local[0].trim(), Integer.parseInt(local[1].trim()), 2000, lockZKProperties.getPassword(), 0, null);
            return jedisPool;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public DistributedLockTemplate distributedLockTemplate(@Qualifier(value="jedisLock") Object jedisLock) {
        return new RedisDistributedLockTemplate(jedisLock);
    }
}

