/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock.redis;

import java.util.ArrayList;
import org.daijie.core.lock.redis.LimitRule;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class AccessSpeedLimit {
    private JedisPool jedisPool;

    public AccessSpeedLimit() {
    }

    public AccessSpeedLimit(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public boolean tryAccess(String key, int seconds, int limitCount) {
        LimitRule limitRule = new LimitRule();
        limitRule.setLimitCount(limitCount);
        limitRule.setSeconds(seconds);
        return this.tryAccess(key, limitRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAccess(String key, LimitRule limitRule) {
        String newKey = "Limit:" + key;
        long count = -1L;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(newKey);
            ArrayList<String> args = new ArrayList<String>();
            args.add(Math.max(limitRule.getLimitCount(), limitRule.getLockCount()) + "");
            args.add(limitRule.getSeconds() + "");
            args.add(limitRule.getLockCount() + "");
            args.add(limitRule.getLockTime() + "");
            count = Long.parseLong(jedis.eval(this.buildLuaScript(limitRule), keys, args) + "");
            boolean bl = count <= (long)limitRule.getLimitCount();
            return bl;
        }
    }

    private String buildLuaScript(LimitRule limitRule) {
        StringBuilder lua = new StringBuilder();
        lua.append("\nlocal c");
        lua.append("\nc = redis.call('get',KEYS[1])");
        lua.append("\nif c and tonumber(c) > tonumber(ARGV[1]) then");
        lua.append("\nreturn c;");
        lua.append("\nend");
        lua.append("\nc = redis.call('incr',KEYS[1])");
        lua.append("\nif tonumber(c) == 1 then");
        lua.append("\nredis.call('expire',KEYS[1],ARGV[2])");
        lua.append("\nend");
        if (limitRule.enableLimitLock()) {
            lua.append("\nif tonumber(c) > tonumber(ARGV[3]) then");
            lua.append("\nredis.call('expire',KEYS[1],ARGV[4])");
            lua.append("\nend");
        }
        lua.append("\nreturn c;");
        return lua.toString();
    }
}

