/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.daijie.core.filter.BodyReaderHttpServletRequestWrapper;
import org.daijie.core.filter.HttpRequestProperties;
import org.springframework.util.StringUtils;

@WebFilter(filterName="parametersFilter", urlPatterns={"/*"}, initParams={@WebInitParam(name="paramName", value="paramValue")})
public class ParametersFilter
implements Filter {
    private static final String REMOTE_AJAX_ORIGIN = "Access-Control-Allow-Origin";
    private static final String REMOTE_AJAX_METHODS = "Access-Control-Allow-Methods";
    private static final String REMOTE_AJAX_HEADERS = "Access-Control-Allow-Headers";
    private final HttpRequestProperties requestProperties;

    public ParametersFilter(HttpRequestProperties requestProperties) {
        this.requestProperties = requestProperties;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)req;
        HttpServletResponse hres = (HttpServletResponse)res;
        if (this.requestProperties.getRemoteAjaxEanble().booleanValue()) {
            hres.addHeader(REMOTE_AJAX_ORIGIN, this.requestProperties.getAccessControlAllowOrigin());
            hres.addHeader(REMOTE_AJAX_METHODS, this.requestProperties.getAccessControlAllowMethods());
            hres.addHeader(REMOTE_AJAX_HEADERS, this.requestProperties.getAccessControlAllowHeaders());
        }
        if (this.requestProperties.getBodyByParamEanble().booleanValue() && !StringUtils.isEmpty((Object)this.requestProperties.getBodyByParamMethods())) {
            String reqMethod = hreq.getMethod().toUpperCase();
            if (this.requestProperties.getBodyByParamMethods().contains(reqMethod)) {
                BodyReaderHttpServletRequestWrapper requestWrapper = new BodyReaderHttpServletRequestWrapper(hreq);
                chain.doFilter((ServletRequest)requestWrapper, res);
                return;
            }
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

