/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.daijie.core.controller.enums.JSONType;
import org.daijie.core.util.http.HttpConversationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyReaderHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static Logger logger = LoggerFactory.getLogger(BodyReaderHttpServletRequestWrapper.class);
    private final byte[] body;
    private Map<String, Object> params = new HashMap<String, Object>();

    public BodyReaderHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.params.putAll(request.getParameterMap());
        String bodyString = HttpConversationUtil.getBodyString();
        logger.info("params = {}", this.params);
        logger.info("body = {}", (Object)bodyString);
        if (bodyString == null || "".equals(bodyString)) {
            this.body = new byte[0];
            return;
        }
        this.body = bodyString.getBytes(Charset.forName("UTF-8"));
        if (request.getContentType().contains("application/json")) {
            String param = new String(this.body, Charset.forName("UTF-8"));
            if (param != null & param.contains("=")) {
                param = param.split("=")[1];
            }
            ObjectMapper mapper = new ObjectMapper();
            if (JSONType.getJSONType(param).equals((Object)JSONType.JSON_TYPE_OBJECT)) {
                this.params.putAll((Map)mapper.readValue(param, Map.class));
            }
        }
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener listener) {
            }

            public int read() throws IOException {
                return bais.read();
            }
        };
    }

    public String getHeader(String name) {
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return super.getHeaderNames();
    }

    public Enumeration<String> getHeaders(String name) {
        return super.getHeaders(name);
    }

    public Map getParameterMap() {
        return this.params;
    }

    public Enumeration getParameterNames() {
        Vector<String> l = new Vector<String>(this.params.keySet());
        return l.elements();
    }

    public String[] getParameterValues(String name) {
        Object v = this.params.get(name);
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            return (String[])v;
        }
        if (v instanceof String) {
            return new String[]{(String)v};
        }
        return new String[]{v.toString()};
    }

    public String getParameter(String name) {
        Object v = this.params.get(name);
        if (v == null) {
            return null;
        }
        if (v instanceof String[]) {
            String[] strArr = (String[])v;
            if (strArr.length > 0) {
                return strArr[0];
            }
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return v.toString();
    }
}

