/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.controller;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.daijie.core.annotation.ErrorMapping;
import org.daijie.core.controller.enums.ResultCode;
import org.daijie.core.controller.exception.ApiException;
import org.daijie.core.result.factory.ModelResultInitialFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Configuration
public class ControllerExceptionHandlerResolver
implements HandlerExceptionResolver,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int order = Integer.MAX_VALUE;
    private String errorMappingPath = "/error";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        this.logger.debug("error uri:" + request.getRequestURI(), (Throwable)exception);
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            Class<?> cls = handlerMethod.getBean().getClass();
            try {
                if (cls.getAnnotations().length == 0) {
                    String typeName = cls.getTypeName();
                    cls = Class.forName(typeName.substring(0, typeName.indexOf("$")));
                }
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            if (cls.isAnnotationPresent(RestController.class) || method.isAnnotationPresent(ResponseBody.class)) {
                try (PrintWriter out = null;){
                    response.setContentType("application/json;charset=utf-8");
                    response.setCharacterEncoding("UTF-8");
                    out = response.getWriter();
                    if (exception instanceof ApiException) {
                        out.write(ModelResultInitialFactory.Result.build(null, exception.getMessage(), false, ((ApiException)exception).getCode()).toJsonStr());
                    } else {
                        out.write(ModelResultInitialFactory.Result.build(null, exception.getMessage(), false, ResultCode.CODE_500).toJsonStr());
                    }
                }
                return new ModelAndView();
            }
            if (cls.isAnnotationPresent(Controller.class)) {
                ErrorMapping errorMapping = method.getAnnotation(ErrorMapping.class);
                if (errorMapping == null) {
                    errorMapping = cls.getAnnotation(ErrorMapping.class);
                }
                if (errorMapping != null && !"".equals(errorMapping.path())) {
                    return new ModelAndView("forward:" + errorMapping.path());
                }
                return new ModelAndView("forward:" + this.errorMappingPath);
            }
        }
        return null;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

