/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util.http;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ImageValidateCodeUtil {
    public static final String CODE_KEY = "code_key";
    private Random random = new Random();
    private String randString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int width = 80;
    private int height = 26;
    private int lineSize = 40;
    private int stringNum = 4;
    private String validateCode = "";

    public ImageValidateCodeUtil() {
    }

    public ImageValidateCodeUtil(int width, int height, int lineSize, int stringNum) {
        this.width = width;
        this.height = height;
        this.lineSize = lineSize;
        this.stringNum = stringNum;
    }

    private Font getFont() {
        return new Font("Fixedsys", 1, 18);
    }

    private Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + this.random.nextInt(bc - fc - 16);
        int g = fc + this.random.nextInt(bc - fc - 14);
        int b = fc + this.random.nextInt(bc - fc - 18);
        return new Color(r, g, b);
    }

    private String drowString(Graphics g, String randomString, int i) {
        g.setFont(this.getFont());
        g.setColor(new Color(this.random.nextInt(101), this.random.nextInt(111), this.random.nextInt(121)));
        String rand = String.valueOf(this.getRandomString(this.random.nextInt(this.randString.length())));
        randomString = randomString + rand;
        g.translate(this.random.nextInt(3), this.random.nextInt(3));
        g.drawString(rand, 13 * i, 16);
        return randomString;
    }

    public String getValidateCode() {
        return this.validateCode;
    }

    private void drowLine(Graphics g) {
        int x = this.random.nextInt(this.width);
        int y = this.random.nextInt(this.height);
        int xl = this.random.nextInt(13);
        int yl = this.random.nextInt(15);
        g.drawLine(x, y, x + xl, y + yl);
    }

    public String getRandomString(int num) {
        return String.valueOf(this.randString.charAt(num));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRandcode(HttpServletRequest request, HttpServletResponse response) {
        int i;
        BufferedImage image = new BufferedImage(this.width, this.height, 4);
        Graphics g = image.getGraphics();
        g.fillRect(0, 0, this.width, this.height);
        g.setFont(new Font("Times New Roman", 0, 18));
        g.setColor(this.getRandColor(110, 133));
        for (i = 0; i <= this.lineSize; ++i) {
            this.drowLine(g);
        }
        for (i = 1; i <= this.stringNum; ++i) {
            this.validateCode = this.drowString(g, this.validateCode, i);
        }
        g.dispose();
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", tmp);
            tmp.close();
            Integer contentLength = tmp.size();
            response.setHeader("content-length", contentLength + "");
            response.getOutputStream().write(tmp.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return this.validateCode;
    }
}

