/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util.http;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;

public class FTPUtil {
    public static FTPClient getFTPClient(String server, String username, String password) throws IOException {
        FTPClient ftpClient = null;
        try {
            ftpClient = new FTPClient();
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.connect(server);
            ftpClient.login(username, password);
        }
        catch (SocketException e) {
            throw new SocketException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        return ftpClient;
    }

    public static void closeFTPClient(FTPClient ftpClient) {
        try {
            try {
                ftpClient.logout();
            }
            finally {
                ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean putFile(FTPClient ftpClient, File f, String uploadDir) throws IOException {
        InputStream instream = null;
        boolean result = false;
        try {
            try {
                ftpClient.setFileType(2);
                if (StringUtils.isNotEmpty((String)uploadDir)) {
                    ftpClient.makeDirectory(uploadDir);
                    ftpClient.changeWorkingDirectory(uploadDir);
                }
                instream = new BufferedInputStream(new FileInputStream(f));
                ftpClient.enterLocalPassiveMode();
                result = ftpClient.storeFile(f.getName(), instream);
            }
            finally {
                if (instream != null) {
                    instream.close();
                }
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        return result;
    }

    public static boolean deleteFile(FTPClient ftpClient, String filepath) throws IOException {
        boolean result = false;
        try {
            result = ftpClient.deleteFile(filepath);
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadFile(FTPClient ftpClient, String uploadDir, String fileName, InputStream instream) throws IOException {
        boolean result = false;
        try {
            try {
                ftpClient.setFileType(2);
                if (StringUtils.isNotEmpty((String)uploadDir)) {
                    ftpClient.makeDirectory(uploadDir);
                    ftpClient.changeWorkingDirectory(uploadDir);
                }
                instream = new BufferedInputStream(instream);
                ftpClient.enterLocalPassiveMode();
                ftpClient.setBufferSize(0x400000);
                result = ftpClient.storeFile(fileName, instream);
            }
            finally {
                if (instream != null) {
                    instream.close();
                }
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        return result;
    }
}

