/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util.encrypt;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.lang.StringUtils;

public class PasswordUtil {
    public static String generatePassword(String plainPassword, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (StringUtils.isBlank((String)plainPassword) || salt == null) {
            throw new NullPointerException("Plain password or salt can't be empty");
        }
        int iterations = 1000;
        char[] chars = plainPassword.toCharArray();
        PBEKeySpec spec = new PBEKeySpec(chars, salt, iterations, 512);
        byte[] hash = SecretKeyFactorySingleTon.skf.generateSecret(spec).getEncoded();
        return PasswordUtil.toHex(hash);
    }

    public static String generateSalt() throws NoSuchAlgorithmException {
        byte[] salt = new byte[32];
        SecureRandomSingleTon.sr.nextBytes(salt);
        return PasswordUtil.toHex(salt);
    }

    private static String toHex(byte[] array) throws NoSuchAlgorithmException {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    private static class SecureRandomSingleTon {
        private static SecureRandom sr = null;

        private SecureRandomSingleTon() {
        }

        static {
            try {
                sr = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
    }

    private static class SecretKeyFactorySingleTon {
        private static SecretKeyFactory skf = null;

        private SecretKeyFactorySingleTon() {
        }

        static {
            try {
                skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
    }
}

