/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.util;

import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdWorker {
    private final long workerId = (long)_genmachine % 1024L;
    private static final long twepoch = 1361753741828L;
    private long sequence = 0L;
    private static final long workerIdBits = 10L;
    private static final long maxWorkerId = 1023L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private long lastTimestamp = -1L;
    private static IdWorker worker = new IdWorker();
    private static final Logger logger = LoggerFactory.getLogger(IdWorker.class);
    private static final int _genmachine;

    public static long getId() {
        return worker.nextId();
    }

    public static String getDayId() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String day = sdf.format(new Date());
        return day + worker.nextId();
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        if (timestamp < this.lastTimestamp) {
            try {
                throw new Exception(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            }
            catch (Exception e) {
                logger.error(" IdWorker error. ", (Throwable)e);
            }
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1361753741828L << 22 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp1) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp1) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public static String getRandomNumber(int length) {
        StringBuilder val = new StringBuilder(length);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            val.append(String.valueOf(random.nextInt(10)));
        }
        return val.toString();
    }

    static {
        try {
            int machinePiece;
            try {
                StringBuilder sb = new StringBuilder();
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    sb.append(ni.toString());
                }
                machinePiece = sb.toString().hashCode() << 16;
            }
            catch (Throwable e) {
                logger.error(" IdWorker error. ", e);
                machinePiece = new Random().nextInt() << 16;
            }
            logger.debug("machine piece post: " + Integer.toHexString(machinePiece));
            int processId = new Random().nextInt();
            try {
                processId = ManagementFactory.getRuntimeMXBean().getName().hashCode();
            }
            catch (Throwable ni) {
                // empty catch block
            }
            ClassLoader loader = IdWorker.class.getClassLoader();
            int loaderId = loader != null ? System.identityHashCode(loader) : 0;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toHexString(processId));
            sb.append(Integer.toHexString(loaderId));
            int processPiece = sb.toString().hashCode() & 0xFFFF;
            logger.debug("process piece: " + Integer.toHexString(processPiece));
            _genmachine = machinePiece | processPiece;
            logger.debug("machine : " + Integer.toHexString(_genmachine));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

