/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.swagger;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.daijie.core.factory.RegisterBeanFactory;
import org.daijie.core.swagger.DocketFactory;
import org.daijie.core.swagger.PackRewirteDocket;
import org.daijie.core.swagger.SwaggerProperties;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.type.AnnotationMetadata;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.ApiSelector;

public abstract class ApiInfoDocketFactory
implements DocketFactory,
RegisterBeanFactory {
    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        ArrayList<SwaggerProperties> properties = new ArrayList<SwaggerProperties>();
        this.docket(properties, registry);
        for (SwaggerProperties swaggerProperties : properties) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(PackRewirteDocket.class);
            builder.addConstructorArgValue((Object)DocumentationType.SWAGGER_2);
            builder.addPropertyValue("apiInfo", (Object)this.apiInfo(swaggerProperties));
            builder.addPropertyValue("groupName", (Object)(properties.size() == 1 ? "default" : swaggerProperties.getGroupName()));
            builder.addPropertyValue("apiSelector", (Object)this.apiSelector(swaggerProperties));
            this.registerBean(swaggerProperties.getGroupName() + "Bean", builder, registry);
        }
    }

    @Override
    public ApiInfo apiInfo(SwaggerProperties swaggerProperties) {
        return new ApiInfoBuilder().title(swaggerProperties.getTitle()).description(swaggerProperties.getDescription()).termsOfServiceUrl(swaggerProperties.getTermsOfServiceUrl()).contact(swaggerProperties.getContact()).version(swaggerProperties.getVersion()).build();
    }

    public ApiSelector apiSelector(SwaggerProperties swaggerProperties) {
        Predicate requestHandlerSelectors = null;
        requestHandlerSelectors = StringUtils.isNotEmpty((String)swaggerProperties.getBasePackage()) ? RequestHandlerSelectors.basePackage((String)swaggerProperties.getBasePackage()) : ApiSelector.DEFAULT.getRequestHandlerSelector();
        return new ApiSelector(Predicates.and((Predicate)requestHandlerSelectors, this.transform((Predicate<String>)PathSelectors.any())), PathSelectors.any());
    }

    private Predicate<RequestHandler> transform(final Predicate<String> pathSelector) {
        return new Predicate<RequestHandler>(){

            public boolean apply(RequestHandler input) {
                return Iterables.any((Iterable)input.getPatternsCondition().getPatterns(), (Predicate)pathSelector);
            }
        };
    }

    @Override
    public void registerBean(String beanName, BeanDefinitionBuilder builder, BeanDefinitionRegistry registry) {
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, beanName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry);
    }
}

