/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.result;

import java.io.Serializable;
import java.util.Map;
import org.daijie.core.controller.enums.ResultCode;
import org.daijie.core.result.ApiResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Conventions;

public class ApiResultWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Logger logger = LoggerFactory.getLogger(ApiResultWrapper.class);
    private ApiResult apiResult = new ApiResult();

    public ApiResultWrapper() {
    }

    public ApiResultWrapper(boolean success) {
        this.apiResult.setSuccess(success);
    }

    public ApiResultWrapper(boolean success, ResultCode code) {
        this.apiResult.setSuccess(success);
        this.apiResult.setCode(code.getValue());
        this.apiResult.setMsg(code.getDescription());
    }

    public ApiResultWrapper(boolean success, ResultCode code, String msg) {
        this.apiResult.setSuccess(success);
        this.apiResult.setCode(code.getValue());
        this.apiResult.setMsg(msg);
    }

    public ApiResultWrapper setSuccess(boolean success) {
        this.apiResult.setSuccess(success);
        return this;
    }

    public ApiResultWrapper setMsg(String msg) {
        this.apiResult.setMsg(msg);
        return this;
    }

    public ApiResultWrapper setCode(ResultCode code) {
        this.apiResult.setCode(code.getValue());
        return this;
    }

    public ApiResultWrapper addDatas(Map<String, Object> dataMap) {
        if (dataMap != null) {
            this.apiResult.getData().putAll(dataMap);
        }
        return this;
    }

    public ApiResultWrapper addData(Object modelData) {
        this.addData(Conventions.getVariableName((Object)modelData), modelData);
        return this;
    }

    public ApiResultWrapper addData(String modelName, Object modelData) {
        this.apiResult.getData().put(modelName, modelData);
        return this;
    }

    public ApiResultWrapper removeData(String modelName) {
        if (this.apiResult.getData().containsKey(modelName)) {
            this.apiResult.getData().remove(modelName);
        }
        return this;
    }

    public ApiResultWrapper clearDatas() {
        this.apiResult.getData().clear();
        return this;
    }

    public ApiResult build() {
        return this.apiResult;
    }
}

