/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.process;

import java.lang.reflect.Array;
import org.daijie.core.factory.IEnumFactory;
import org.daijie.core.process.Process;
import org.daijie.core.process.ProcessHandle;
import org.daijie.core.process.TreeProcess;

public class TreeEnumProcess<E extends IEnumFactory<E>>
implements ProcessHandle<E> {
    private static final long serialVersionUID = -6144753183618957937L;
    protected transient int modCount;
    private transient int size;
    private transient TreeProcess<E> firstProcess;
    private transient TreeProcess<E> lastProcess;

    private void linkFirst(E element) {
        TreeProcess<E> newFirstProcess = this.firstProcess;
        TreeProcess[] newFirstProcesses = null;
        if (newFirstProcess != null) {
            newFirstProcesses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
            newFirstProcesses[0] = newFirstProcess;
        }
        TreeProcess<E> newProcess = new TreeProcess<E>(null, element, newFirstProcess, null, newFirstProcesses);
        this.firstProcess = newProcess;
        if (newFirstProcess == null) {
            this.lastProcess = newProcess;
        } else {
            TreeProcess[] newPreviousProcessses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
            newPreviousProcessses[0] = newProcess;
            newFirstProcess.defaultPrevious = newProcess;
            newFirstProcess.previousProcesses = newPreviousProcessses;
        }
        ++this.size;
        ++this.modCount;
    }

    private void linkLast(E element) {
        TreeProcess<E> newLastProcess = this.lastProcess;
        TreeProcess[] newLastProcesses = null;
        if (newLastProcess != null) {
            newLastProcesses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
            newLastProcesses[0] = newLastProcess;
        }
        TreeProcess<E> newProcess = new TreeProcess<E>(newLastProcess, element, null, newLastProcesses, null);
        this.lastProcess = newProcess;
        if (newLastProcess == null) {
            this.firstProcess = newProcess;
        } else {
            TreeProcess[] newNextProcessses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
            newNextProcessses[0] = newProcess;
            newLastProcess.defaultNext = newProcess;
            newLastProcess.nextProcesses = newNextProcessses;
        }
        ++this.size;
        ++this.modCount;
    }

    private void linkBefore(E element, TreeProcess<E> process) {
        TreeProcess defaultPrevious = process.defaultPrevious;
        TreeProcess<E>[] previousProcesses = process.previousProcesses;
        TreeProcess[] newLastProcesses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
        newLastProcesses[0] = process;
        TreeProcess newProcess = new TreeProcess(defaultPrevious, element, process, previousProcesses, newLastProcesses);
        process.defaultPrevious = newProcess;
        if (defaultPrevious == null) {
            this.firstProcess = newProcess;
        } else {
            TreeProcess[] newNextProcessses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
            newNextProcessses[0] = newProcess;
            defaultPrevious.defaultNext = newProcess;
            defaultPrevious.nextProcesses = newNextProcessses;
        }
        ++this.size;
        ++this.modCount;
    }

    private void linkAfter(E element, TreeProcess<E> process) {
        TreeProcess defaultNext = process.defaultNext;
        TreeProcess<E>[] nextProcesses = process.nextProcesses;
        TreeProcess[] newPreviosProcesses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
        newPreviosProcesses[0] = process;
        TreeProcess<E> newProcess = new TreeProcess<E>(process, element, defaultNext, newPreviosProcesses, nextProcesses);
        process.defaultNext = newProcess;
        if (defaultNext == null) {
            this.lastProcess = newProcess;
        } else {
            TreeProcess[] newPreviousProcessses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
            newPreviousProcessses[0] = newProcess;
            defaultNext.defaultPrevious = newProcess;
            defaultNext.previousProcesses = newPreviousProcessses;
        }
        ++this.size;
        ++this.modCount;
    }

    private void linkBranch(TreeProcess<E> beginProcess, E element) {
        TreeProcess<E>[] nextProcesses = beginProcess.nextProcesses;
        TreeProcess[] newPreviosProcesses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
        newPreviosProcesses[0] = beginProcess;
        TreeProcess<E> newProcess = new TreeProcess<E>(beginProcess, element, null, newPreviosProcesses, null);
        TreeProcess[] newNextProcessses = (TreeProcess[])Array.newInstance(TreeProcess.class, nextProcesses.length + 1);
        for (int i = 0; i < nextProcesses.length; ++i) {
            if (nextProcesses[i].element == element) {
                return;
            }
            newNextProcessses[i] = nextProcesses[i];
        }
        nextProcesses = newNextProcessses;
        nextProcesses[newNextProcessses.length - 1] = newProcess;
        beginProcess.nextProcesses = nextProcesses;
        if (beginProcess.defaultNext == null) {
            beginProcess.defaultNext = newProcess;
        }
        ++this.size;
        ++this.modCount;
    }

    private void linkBranch(TreeProcess<E> beginProcess, E element, Process processEnum) {
        TreeProcess<E>[] nextProcesses = beginProcess.nextProcesses;
        TreeProcess[] newPreviosProcesses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
        newPreviosProcesses[0] = beginProcess;
        TreeProcess<E> newProcess = new TreeProcess<E>(beginProcess, element, null, newPreviosProcesses, null);
        newProcess.process = processEnum;
        TreeProcess[] newNextProcessses = (TreeProcess[])Array.newInstance(TreeProcess.class, nextProcesses.length + 1);
        for (int i = 0; i < nextProcesses.length; ++i) {
            if (nextProcesses[i].element == element) {
                return;
            }
            newNextProcessses[i] = nextProcesses[i];
        }
        nextProcesses = newNextProcessses;
        nextProcesses[newNextProcessses.length - 1] = newProcess;
        beginProcess.nextProcesses = nextProcesses;
        if (beginProcess.defaultNext == null) {
            beginProcess.defaultNext = newProcess;
        }
        ++this.size;
        ++this.modCount;
    }

    private void setLinkBranch(TreeProcess<E> beginProcess, TreeProcess<E> process) {
        TreeProcess[] newNextProcessses = (TreeProcess[])Array.newInstance(TreeProcess.class, beginProcess.nextProcesses.length + 1);
        for (int i = 0; i < beginProcess.nextProcesses.length; ++i) {
            if (beginProcess.nextProcesses[i].element == process.element) {
                return;
            }
            newNextProcessses[i] = beginProcess.nextProcesses[i];
        }
        beginProcess.nextProcesses = newNextProcessses;
        beginProcess.nextProcesses[newNextProcessses.length - 1] = process;
        if (beginProcess.defaultNext == null) {
            beginProcess.defaultNext = process;
        }
        TreeProcess[] newPreviousProcessses = (TreeProcess[])Array.newInstance(TreeProcess.class, process.previousProcesses.length + 1);
        for (int i = 0; i < process.previousProcesses.length; ++i) {
            newPreviousProcessses[i] = process.previousProcesses[i];
        }
        process.previousProcesses = newPreviousProcessses;
        process.previousProcesses[newPreviousProcessses.length - 1] = beginProcess;
        if (process.defaultPrevious == null) {
            process.defaultPrevious = beginProcess;
        }
    }

    private void linkBranch(TreeProcess<E> beginProcess, E element, TreeProcess<E> endProcess) {
        TreeProcess<E>[] nextProcesses = beginProcess.nextProcesses;
        TreeProcess[] newPreviosProcesses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
        newPreviosProcesses[0] = beginProcess;
        TreeProcess[] newLastProcesses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
        newLastProcesses[0] = endProcess;
        TreeProcess<E> newProcess = new TreeProcess<E>(beginProcess, element, endProcess, newPreviosProcesses, newLastProcesses);
        TreeProcess[] newNextProcessses = (TreeProcess[])Array.newInstance(TreeProcess.class, nextProcesses.length + 1);
        for (int i = 0; i < nextProcesses.length; ++i) {
            if (nextProcesses[i].element == element) {
                return;
            }
            newNextProcessses[i] = nextProcesses[i];
        }
        nextProcesses = newNextProcessses;
        nextProcesses[newNextProcessses.length - 1] = newProcess;
        ++this.modCount;
    }

    private void linkBranch(TreeProcess<E> beginProcess, E element, TreeProcess<E> endProcess, Process processEnum) {
        TreeProcess<E>[] nextProcesses = beginProcess.nextProcesses;
        TreeProcess[] newPreviosProcesses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
        newPreviosProcesses[0] = beginProcess;
        TreeProcess[] newLastProcesses = (TreeProcess[])Array.newInstance(TreeProcess.class, 1);
        newLastProcesses[0] = endProcess;
        TreeProcess<E> newProcess = new TreeProcess<E>(beginProcess, element, endProcess, newPreviosProcesses, newLastProcesses);
        newProcess.process = processEnum;
        TreeProcess[] newNextProcessses = (TreeProcess[])Array.newInstance(TreeProcess.class, nextProcesses.length + 1);
        for (int i = 0; i < nextProcesses.length; ++i) {
            if (nextProcesses[i].element == element) {
                return;
            }
            newNextProcessses[i] = nextProcesses[i];
        }
        nextProcesses = newNextProcessses;
        nextProcesses[newNextProcessses.length - 1] = newProcess;
        ++this.modCount;
    }

    private void setLinkBranch(TreeProcess<E> beginProcess, TreeProcess<E> process, TreeProcess<E> endProcess) {
        this.setLinkBranch(beginProcess, process);
        this.setLinkBranch(process, endProcess);
    }

    boolean linkDefaultBranch(TreeProcess<E> beginProcess, E element) {
        TreeProcess<E>[] nextProcesses;
        for (TreeProcess process : nextProcesses = beginProcess.nextProcesses) {
            if (!((IEnumFactory)process.element).equals(element)) continue;
            process.process = Process.THROUGH;
            beginProcess.defaultNext = process;
            return true;
        }
        return false;
    }

    TreeProcess<E> recursionNode(TreeProcess<E> process, E element) {
        if (process != null) {
            if (((IEnumFactory)process.element).equals(element)) {
                return process;
            }
            for (TreeProcess enumProcess : process.nextProcesses) {
                if (this.upwardRecursionNode(process, (IEnumFactory)enumProcess.element) != null) {
                    return null;
                }
                TreeProcess obj = this.recursionNode(enumProcess, element);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    TreeProcess<E> upwardRecursionNode(TreeProcess<E> process, E element) {
        if (((IEnumFactory)process.element).equals(element)) {
            return process;
        }
        if (process.defaultPrevious == null) {
            return null;
        }
        if (((IEnumFactory)process.defaultPrevious.element).equals(element)) {
            return process.defaultPrevious;
        }
        return this.upwardRecursionNode(process.defaultPrevious, element);
    }

    public boolean addBranch(E beginElement, E element) {
        TreeProcess<E> process = this.recursionNode(this.firstProcess, beginElement);
        if (process != null && ((IEnumFactory)process.element).equals(beginElement)) {
            this.linkBranch(process, element);
            return true;
        }
        return false;
    }

    public boolean addBranch(E beginElement, E element, Process processEnum) {
        TreeProcess<E> process = this.recursionNode(this.firstProcess, beginElement);
        if (process != null && ((IEnumFactory)process.element).equals(beginElement)) {
            this.linkBranch(process, element, processEnum);
            return true;
        }
        return false;
    }

    public boolean setBranch(E beginElement, E element) {
        TreeProcess<E> beginProcess = this.recursionNode(this.firstProcess, beginElement);
        TreeProcess<E> process = this.recursionNode(this.firstProcess, element);
        if (beginProcess != null && ((IEnumFactory)beginProcess.element).equals(beginElement)) {
            if (process == null) {
                this.linkBranch(beginProcess, element);
            } else {
                this.setLinkBranch(beginProcess, process);
            }
            return true;
        }
        return false;
    }

    public boolean setBranch(E beginElement, E element, Process processEnum) {
        TreeProcess<E> beginProcess = this.recursionNode(this.firstProcess, beginElement);
        TreeProcess<E> process = this.recursionNode(this.firstProcess, element);
        if (beginProcess != null && ((IEnumFactory)beginProcess.element).equals(beginElement)) {
            if (process == null) {
                this.linkBranch(beginProcess, element, processEnum);
            } else {
                process.process = processEnum;
                this.setLinkBranch(beginProcess, process);
            }
            return true;
        }
        return false;
    }

    public boolean addBranch(E beginElement, E element, E endElement) {
        TreeProcess<E> beginProcess = this.recursionNode(this.firstProcess, beginElement);
        TreeProcess<E> endProcess = this.recursionNode(this.firstProcess, endElement);
        if (beginProcess != null && ((IEnumFactory)beginProcess.element).equals(beginElement) && endProcess != null && ((IEnumFactory)endProcess.element).equals(endElement)) {
            this.linkBranch(beginProcess, element, endProcess);
            return true;
        }
        return false;
    }

    public boolean addBranch(E beginElement, E element, E endElement, Process processEnum) {
        TreeProcess<E> beginProcess = this.recursionNode(this.firstProcess, beginElement);
        TreeProcess<E> endProcess = this.recursionNode(this.firstProcess, endElement);
        if (beginProcess != null && ((IEnumFactory)beginProcess.element).equals(beginElement) && endProcess != null && ((IEnumFactory)endProcess.element).equals(endElement)) {
            this.linkBranch(beginProcess, element, endProcess, processEnum);
            return true;
        }
        return false;
    }

    public boolean setBranch(E beginElement, E element, E endElement) {
        TreeProcess<E> beginProcess = this.recursionNode(this.firstProcess, beginElement);
        TreeProcess<E> process = this.recursionNode(this.firstProcess, element);
        TreeProcess<E> endProcess = this.recursionNode(this.firstProcess, endElement);
        if (beginProcess != null && ((IEnumFactory)beginProcess.element).equals(beginElement) && endProcess != null && ((IEnumFactory)endProcess.element).equals(endElement)) {
            if (process == null) {
                this.linkBranch(beginProcess, element, endProcess);
            } else {
                this.setLinkBranch(beginProcess, process, endProcess);
            }
            return true;
        }
        return false;
    }

    public boolean setBranch(E beginElement, E element, E endElement, Process processEnum) {
        TreeProcess<E> beginProcess = this.recursionNode(this.firstProcess, beginElement);
        TreeProcess<E> process = this.recursionNode(this.firstProcess, element);
        TreeProcess<E> endProcess = this.recursionNode(this.firstProcess, endElement);
        if (beginProcess != null && ((IEnumFactory)beginProcess.element).equals(beginElement) && endProcess != null && ((IEnumFactory)endProcess.element).equals(endElement)) {
            if (process == null) {
                this.linkBranch(beginProcess, element, endProcess, processEnum);
            } else {
                process.process = processEnum;
                this.setLinkBranch(beginProcess, process, endProcess);
            }
            return true;
        }
        return false;
    }

    public boolean defaultBranch(E beginElement, E element) {
        TreeProcess<E> beginProcess = this.recursionNode(this.firstProcess, beginElement);
        return this.linkDefaultBranch(beginProcess, element);
    }

    public boolean addFirst(E element) {
        this.linkFirst(element);
        return true;
    }

    public boolean addLast(E element) {
        this.linkLast(element);
        return true;
    }

    @Override
    public boolean add(E element) {
        TreeProcess<E> process = this.recursionNode(this.firstProcess, element);
        if (process == null) {
            this.linkLast(element);
        }
        return true;
    }

    @Override
    public boolean add(E[] elements) {
        for (E element : elements) {
            TreeProcess<E> process = this.recursionNode(this.firstProcess, element);
            if (process != null) continue;
            this.linkLast(element);
        }
        return true;
    }

    public boolean add(E from, E to, Process processEnum) {
        this.add(from);
        this.setBranch(from, to, (E)((Object)processEnum));
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public E next(E element) {
        TreeProcess<E> process = this.recursionNode(this.firstProcess, element);
        if (process == null || process.defaultNext == null) {
            return null;
        }
        return (E)((IEnumFactory)process.defaultNext.element);
    }

    @Override
    public E next(E element, Process processEnum) {
        TreeProcess<E>[] nextProcesses;
        for (TreeProcess enumProcess : nextProcesses = this.recursionNode(this.firstProcess, element).nextProcesses) {
            if (enumProcess.process != processEnum) continue;
            return (E)((IEnumFactory)enumProcess.element);
        }
        return null;
    }

    public E pre(E element) {
        TreeProcess<E> process = this.recursionNode(this.firstProcess, element);
        if (process == null || process.defaultPrevious == null) {
            return null;
        }
        return (E)((IEnumFactory)process.defaultPrevious.element);
    }

    @Override
    public E pre(E element, Process processEnum) {
        TreeProcess<E>[] previousProcesses;
        for (TreeProcess enumProcess : previousProcesses = this.recursionNode(this.firstProcess, element).previousProcesses) {
            for (TreeProcess nextProcess : enumProcess.nextProcesses) {
                if (nextProcess.process != processEnum) continue;
                return (E)((IEnumFactory)enumProcess.element);
            }
        }
        return null;
    }
}

