/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.process;

import org.daijie.core.process.LinkedProcess;
import org.daijie.core.process.Process;
import org.daijie.core.process.ProcessHandle;

public class LinkedEnumProcess<E>
implements ProcessHandle<E> {
    private static final long serialVersionUID = -9012969703888523924L;
    protected transient int modCount = 0;
    transient int size = 0;
    transient LinkedProcess<E> first;
    transient LinkedProcess<E> last;

    private void linkFirst(E element) {
        LinkedProcess<E> firstNode = this.first;
        LinkedProcess<E> newNode = new LinkedProcess<E>(null, element, firstNode);
        this.first = newNode;
        if (firstNode == null) {
            this.last = newNode;
        } else {
            firstNode.previous = newNode;
        }
        ++this.size;
        ++this.modCount;
    }

    private void linkLast(E element) {
        LinkedProcess<E> lastNode = this.last;
        LinkedProcess<E> newNode = new LinkedProcess<E>(lastNode, element, null);
        this.last = newNode;
        if (lastNode == null) {
            this.first = newNode;
        } else {
            lastNode.next = newNode;
        }
        ++this.size;
        ++this.modCount;
    }

    private void linkBefore(E element, LinkedProcess<E> process) {
        LinkedProcess previous = process.previous;
        LinkedProcess newNode = new LinkedProcess(previous, element, process);
        process.previous = newNode;
        if (previous == null) {
            this.first = newNode;
        } else {
            previous.next = newNode;
        }
        ++this.size;
        ++this.modCount;
    }

    private E unlink(LinkedProcess<E> process) {
        Object element = process.element;
        LinkedProcess next = process.next;
        LinkedProcess previous = process.previous;
        if (previous == null) {
            this.first = next;
        } else {
            previous.next = next;
            process.previous = null;
        }
        if (next == null) {
            this.last = previous;
        } else {
            next.previous = previous;
            process.next = null;
        }
        process.element = null;
        --this.size;
        ++this.modCount;
        return element;
    }

    private LinkedProcess<E> processNode(int index) {
        if (index < this.size >> 1) {
            LinkedProcess<E> process = this.first;
            for (int i = 0; i < index; ++i) {
                process = process.next;
            }
            return process;
        }
        LinkedProcess<E> process = this.last;
        for (int i = this.size - 1; i > index; --i) {
            process = process.previous;
        }
        return process;
    }

    public boolean addFirst(E element) {
        this.linkFirst(element);
        return true;
    }

    public boolean addLast(E element) {
        this.linkLast(element);
        return true;
    }

    @Override
    public boolean add(E element) {
        this.linkLast(element);
        return true;
    }

    @Override
    public boolean add(E[] elements) {
        for (E element : elements) {
            this.linkLast(element);
        }
        return true;
    }

    public boolean add(int index, E element) {
        if (index == this.size) {
            this.linkLast(element);
        } else {
            this.linkBefore(element, this.processNode(index));
        }
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean remove(E element) {
        LinkedProcess<E> node = this.first;
        while (node != null) {
            if (element == null && node == null || element.equals(node.element)) {
                this.unlink(node);
                return true;
            }
            node = node.next;
        }
        return false;
    }

    public E get(int index) {
        return this.processNode((int)index).element;
    }

    public E getNext(int index) {
        return this.processNode((int)index).next.element;
    }

    public E getPre(int index) {
        return this.processNode((int)index).previous.element;
    }

    public E next(E element) {
        return this.next(element, Process.THROUGH);
    }

    @Override
    public E next(E element, Process processEnum) {
        if (processEnum == Process.NOT_THROUGH) {
            return this.processNode((int)this.size).element;
        }
        LinkedProcess<E> node = this.first;
        while (node != null) {
            if (element == null && node == null || element.equals(node.element)) {
                return node.next.element;
            }
            node = node.next;
        }
        return null;
    }

    public E pre(E element) {
        return this.pre(element, Process.THROUGH);
    }

    @Override
    public E pre(E element, Process processEnum) {
        LinkedProcess<E> node = this.first;
        while (node != null) {
            if (element == null && node == null || element.equals(node.element)) {
                return node.previous.element;
            }
            node = node.next;
        }
        return null;
    }
}

