/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock.zk;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.log4j.Logger;

public class ZkReentrantLockCleanerTask
extends TimerTask {
    private static final Logger logger = Logger.getLogger(ZkReentrantLockCleanerTask.class);
    private CuratorFramework client;
    private Timer timer;
    private long period = 5000L;
    private int maxRetries = 3;
    private final int baseSleepTimeMs = 1000;

    public ZkReentrantLockCleanerTask(String zookeeperAddress) {
        try {
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, this.maxRetries);
            this.client = CuratorFrameworkFactory.newClient((String)zookeeperAddress, (RetryPolicy)retryPolicy);
            this.client.start();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.error((Object)ex.getMessage(), ex);
        }
    }

    public void start() {
        this.timer.schedule((TimerTask)this, 0L, this.period);
    }

    private boolean isEmpty(List<String> list) {
        return list == null || list.isEmpty();
    }

    @Override
    public void run() {
        try {
            List childrenPaths = (List)this.client.getChildren().forPath("/ROOT_LOCK/");
            for (String path : childrenPaths) {
                this.cleanNode(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cleanNode(String path) {
        try {
            if (this.isEmpty((List)this.client.getChildren().forPath(path))) {
                this.client.delete().forPath(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

