/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock.zk;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import org.daijie.core.lock.zk.DistributedSequence;
import org.daijie.core.lock.zk.ZkReentrantLockCleanerTask;

public class ZkDistributedSequence
implements DistributedSequence {
    private static final Logger logger = Logger.getLogger(ZkReentrantLockCleanerTask.class);
    private CuratorFramework client;
    private int maxRetries = 3;
    private final int baseSleepTimeMs = 1000;

    public ZkDistributedSequence(String zookeeperAddress) {
        try {
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, this.maxRetries);
            this.client = CuratorFrameworkFactory.newClient((String)zookeeperAddress, (RetryPolicy)retryPolicy);
            this.client.start();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.error((Object)ex.getMessage(), ex);
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getBaseSleepTimeMs() {
        return 1000;
    }

    @Override
    public Long sequence(String sequenceName) {
        try {
            int value = ((Stat)((BackgroundPathAndBytesable)this.client.setData().withVersion(-1)).forPath("/" + sequenceName, "".getBytes())).getVersion();
            return new Long(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

