/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock.redis;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.daijie.core.lock.DistributedReentrantLock;
import org.daijie.core.lock.redis.RedisLockInternals;

public class RedisReentrantLock
implements DistributedReentrantLock {
    private final ConcurrentMap<Thread, LockData> threadData = Maps.newConcurrentMap();
    private RedisLockInternals internals;
    private String lockId;

    public RedisReentrantLock(Object jedisLock, String lockId) {
        this.lockId = lockId;
        this.internals = new RedisLockInternals(jedisLock);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        Thread currentThread = Thread.currentThread();
        LockData lockData = (LockData)this.threadData.get(currentThread);
        if (lockData != null) {
            lockData.lockCount.incrementAndGet();
            return true;
        }
        String lockVal = this.internals.tryRedisLock(this.lockId, timeout, unit);
        if (lockVal != null) {
            LockData newLockData = new LockData(currentThread, lockVal);
            this.threadData.put(currentThread, newLockData);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        Thread currentThread = Thread.currentThread();
        LockData lockData = (LockData)this.threadData.get(currentThread);
        if (lockData == null) {
            throw new IllegalMonitorStateException("You do not own the lock: " + this.lockId);
        }
        int newLockCount = lockData.lockCount.decrementAndGet();
        if (newLockCount > 0) {
            return;
        }
        if (newLockCount < 0) {
            throw new IllegalMonitorStateException("Lock count has gone negative for lock: " + this.lockId);
        }
        try {
            this.internals.unlockRedisLock(this.lockId, lockData.lockVal);
        }
        finally {
            this.threadData.remove(currentThread);
        }
    }

    private static class LockData {
        final String lockVal;
        final AtomicInteger lockCount = new AtomicInteger(1);

        private LockData(Thread owningThread, String lockVal) {
            this.lockVal = lockVal;
        }
    }
}

