/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.lock.redis;

import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.daijie.core.lock.Callback;
import org.daijie.core.lock.DistributedLockTemplate;
import org.daijie.core.lock.redis.RedisReentrantLock;

public class RedisDistributedLockTemplate
implements DistributedLockTemplate {
    private static final Logger logger = Logger.getLogger(RedisDistributedLockTemplate.class);
    private Object jedisLock;

    public RedisDistributedLockTemplate(Object jedisLock) {
        this.jedisLock = jedisLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(String lockId, int timeout, Callback callback) {
        RedisReentrantLock distributedReentrantLock = null;
        boolean getLock = false;
        try {
            distributedReentrantLock = new RedisReentrantLock(this.jedisLock, lockId);
            if (distributedReentrantLock.tryLock(new Long(timeout), TimeUnit.MILLISECONDS)) {
                getLock = true;
                Object object = callback.onGetLock();
                return object;
            }
            Object object = callback.onTimeout();
            return object;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.debug((Object)e.getMessage(), (Throwable)e);
            Object object = callback.onError(e);
            return object;
        }
        finally {
            if (getLock) {
                distributedReentrantLock.unlock();
            }
        }
    }
}

