/*
 * Decompiled with CFR 0.152.
 */
package org.daijie.core.kisso.captcha;

import com.baomidou.kisso.common.captcha.background.LineNoiseBackgroundFactory;
import com.baomidou.kisso.common.captcha.color.RandomColorFactory;
import com.baomidou.kisso.common.captcha.filter.predefined.WobbleRippleFilterFactory;
import com.baomidou.kisso.common.captcha.font.RandomFontFactory;
import com.baomidou.kisso.common.captcha.font.UpperRandomWordFactory;
import com.baomidou.kisso.common.captcha.service.AbstractCaptchaService;
import com.baomidou.kisso.common.captcha.service.Captcha;
import com.baomidou.kisso.common.captcha.text.renderer.RandomYBestFitTextRenderer;
import java.awt.image.BufferedImage;

public class KissoCaptchaService
extends AbstractCaptchaService {
    public KissoCaptchaService() {
        this.backgroundFactory = new LineNoiseBackgroundFactory();
        this.wordFactory = new UpperRandomWordFactory();
        this.fontFactory = new RandomFontFactory();
        this.textRenderer = new RandomYBestFitTextRenderer();
        this.colorFactory = new RandomColorFactory();
        this.filterFactory = new WobbleRippleFilterFactory();
        this.textRenderer = new RandomYBestFitTextRenderer();
    }

    public Captcha getCaptcha() {
        BufferedImage bufImage = new BufferedImage(this.width, this.height, 4);
        this.backgroundFactory.fillBackground(bufImage);
        String word = this.wordFactory.getNextWord();
        word = word.replaceAll("0", "8").replaceAll("o", "p").replaceAll("O", "R").replaceAll("l", "L");
        this.textRenderer.draw(word, bufImage, this.fontFactory, this.colorFactory);
        bufImage = this.filterFactory.applyFilters(bufImage);
        return new Captcha(word, bufImage);
    }
}

