/*
 * Decompiled with CFR 0.152.
 */
package org.cubeengine.maven.plugins.pericopist.mojo;

import java.io.File;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.cubeengine.pericopist.Pericopist;
import org.cubeengine.pericopist.PericopistFactory;
import org.cubeengine.pericopist.exception.ConfigurationException;
import org.cubeengine.pericopist.exception.ConfigurationNotFoundException;
import org.cubeengine.pericopist.exception.PericopistException;
import org.cubeengine.pericopist.exception.SourceDirectoryNotExistingException;

public abstract class AbstractPericopistMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project = null;
    @Parameter
    private String[] configurations = null;
    @Parameter
    private int readTimeout = 5000;
    @Parameter(defaultValue="${project.build.sourceEncoding}", readonly=true)
    private String charsetName = null;
    private String classpath = System.getProperty("java.class.path");

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project == null) {
            throw new MojoFailureException("It's not a maven project, isn't it?");
        }
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Skipped the project '" + this.project.getName() + "' ..."));
            return;
        }
        if (this.configurations == null || this.configurations.length == 0) {
            throw new MojoFailureException("A pericopist configuration is not specified.");
        }
        this.loadClasspath();
        Pericopist catalog = this.getPericopist(new PericopistFactory());
        if (catalog == null) {
            throw new MojoFailureException("The template could not be created. Did not find any of the specified configurations.");
        }
        try {
            this.doExecute(catalog);
        }
        catch (SourceDirectoryNotExistingException e) {
            this.getLog().info((CharSequence)e.getMessage());
            this.getLog().info((CharSequence)("Skipped the project '" + this.project.getName() + "'' ..."), (Throwable)e);
        }
        catch (PericopistException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        System.setProperty("java.class.path", this.classpath);
    }

    private Context getVelocityContext() {
        ToolManager toolManager = new ToolManager();
        ToolContext velocityContext = toolManager.createContext();
        velocityContext.put("project", (Object)this.project.getModel());
        velocityContext.put("artifactId", (Object)this.project.getArtifactId());
        velocityContext.put("groupId", (Object)this.project.getGroupId());
        velocityContext.put("version", (Object)this.project.getVersion());
        velocityContext.put("basedir", (Object)this.project.getBasedir());
        velocityContext.put("sourceEncoding", (Object)this.charsetName);
        Properties properties = this.project.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            velocityContext.put((String)entry.getKey(), entry.getValue());
        }
        return velocityContext;
    }

    private Charset getCharset() {
        if (this.charsetName != null) {
            return Charset.forName(this.charsetName);
        }
        return Charset.forName("UTF-8");
    }

    private Pericopist getPericopist(PericopistFactory factory) throws MojoFailureException, MojoExecutionException {
        Context velocityContext = this.getVelocityContext();
        Charset charset = this.getCharset();
        for (String configuration : this.configurations) {
            this.getLog().info((CharSequence)("uses pericopist configuration '" + configuration + "'."));
            try {
                return factory.getPericopist(configuration, charset, this.readTimeout, velocityContext, null);
            }
            catch (ConfigurationNotFoundException e) {
                this.getLog().info((CharSequence)("Configuration not found: " + configuration));
            }
            catch (ConfigurationException e) {
                throw new MojoFailureException("Failed to read the configuration '" + configuration + "'!", (Throwable)e);
            }
            catch (PericopistException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return null;
    }

    private void loadClasspath() throws MojoFailureException {
        try {
            HashSet elements = new HashSet();
            elements.addAll(this.project.getCompileClasspathElements());
            elements.addAll(this.project.getRuntimeClasspathElements());
            elements.addAll(this.project.getSystemClasspathElements());
            elements.addAll(this.project.getTestClasspathElements());
            StringBuilder classpath = new StringBuilder(this.classpath);
            for (Object element : elements) {
                classpath.append(File.pathSeparator);
                classpath.append(element.toString());
            }
            System.setProperty("java.class.path", classpath.toString());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException("The dependencies of the maven project couldn't be loaded.", (Throwable)e);
        }
    }

    protected abstract void doExecute(Pericopist var1) throws PericopistException;
}

