/*
 * Decompiled with CFR 0.152.
 */
package com.builder.uk.watchme;

import com.builder.uk.watchme.WatchMeBean;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class WatchMeFrame
extends JFrame
implements PropertyChangeListener {
    WatchMeBean watchMeBean;
    JLabel count;
    JLabel msg;

    public WatchMeFrame() {
        super("WatchMe");
        this.setLayout(new GridLayout(3, 2));
        this.count = new JLabel("");
        this.msg = new JLabel("");
        this.add(new JLabel("Count:"));
        this.add(this.count);
        this.add(new JLabel("Message:"));
        this.add(this.msg);
        JButton inc = new JButton("Increment");
        this.add(inc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WatchMeFrame.this.windowClosed();
            }
        });
        inc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WatchMeFrame.this.buttonPressed();
            }
        });
    }

    public void setWatchMeBean(WatchMeBean watchMeBean) {
        this.watchMeBean = watchMeBean;
        this.count.setText(Integer.toString(watchMeBean.getCount()));
        this.msg.setText(watchMeBean.getMsg());
        watchMeBean.addPropertyChangeListener(this);
    }

    protected void buttonPressed() {
        if (this.watchMeBean != null) {
            this.watchMeBean.incCount();
        }
    }

    protected void windowClosed() {
        System.exit(0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propname = evt.getPropertyName();
        if (propname.equals("msg")) {
            this.msg.setText((String)evt.getNewValue());
        } else if (propname.equals("count")) {
            this.count.setText(((Integer)evt.getNewValue()).toString());
        }
    }
}

