/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.mac;

import java.lang.foreign.MemorySegment;
import java.time.Instant;
import org.cryptomator.jfuse.api.TimeSpec;
import org.cryptomator.jfuse.mac.extr.stat_h;
import org.cryptomator.jfuse.mac.extr.timespec;

record TimeSpecImpl(MemorySegment segment) implements TimeSpec
{
    public boolean isUtimeOmit() {
        long nanos = timespec.tv_nsec$get(this.segment);
        return (long)stat_h.UTIME_OMIT() == nanos;
    }

    public boolean isUtimeNow() {
        long nanos = timespec.tv_nsec$get(this.segment);
        return (long)stat_h.UTIME_NOW() == nanos;
    }

    public void set(Instant newValue) {
        timespec.tv_sec$set(this.segment, newValue.getEpochSecond());
        timespec.tv_nsec$set(this.segment, newValue.getNano());
    }

    public Instant get() {
        long seconds = timespec.tv_sec$get(this.segment);
        long nanos = timespec.tv_nsec$get(this.segment);
        return Instant.ofEpochSecond(seconds, nanos);
    }
}

