/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.mac;

import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import org.cryptomator.jfuse.api.Statvfs;
import org.cryptomator.jfuse.mac.extr.statvfs;

record StatvfsImpl(MemorySegment segment) implements Statvfs
{
    public StatvfsImpl(MemoryAddress address, MemorySession scope) {
        this(statvfs.ofAddress(address, scope));
    }

    public long getBsize() {
        return statvfs.f_bsize$get(this.segment);
    }

    public void setBsize(long bsize) {
        statvfs.f_bsize$set(this.segment, bsize);
    }

    public long getFrsize() {
        return statvfs.f_frsize$get(this.segment);
    }

    public void setFrsize(long frsize) {
        statvfs.f_frsize$set(this.segment, frsize);
    }

    public long getBlocks() {
        return statvfs.f_blocks$get(this.segment);
    }

    public void setBlocks(long blocks) {
        if (blocks > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Max supported number of blocks: 2147483647");
        }
        statvfs.f_blocks$set(this.segment, (int)blocks);
    }

    public long getBfree() {
        return statvfs.f_bfree$get(this.segment);
    }

    public void setBfree(long bfree) {
        if (bfree > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Max supported number of blocks: 2147483647");
        }
        statvfs.f_bfree$set(this.segment, (int)bfree);
    }

    public long getBavail() {
        return statvfs.f_bavail$get(this.segment);
    }

    public void setBavail(long bavail) {
        if (bavail > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Max supported number of blocks: 2147483647");
        }
        statvfs.f_bavail$set(this.segment, (int)bavail);
    }

    public long getNameMax() {
        return statvfs.f_namemax$get(this.segment);
    }

    public void setNameMax(long namemax) {
        statvfs.f_namemax$set(this.segment, namemax);
    }
}

