/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.mac;

import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import org.cryptomator.jfuse.api.Stat;
import org.cryptomator.jfuse.api.TimeSpec;
import org.cryptomator.jfuse.mac.TimeSpecImpl;
import org.cryptomator.jfuse.mac.extr.stat;
import org.cryptomator.jfuse.mac.extr.stat_h;

record StatImpl(MemorySegment segment) implements Stat
{
    public StatImpl(MemoryAddress address, MemorySession scope) {
        this(stat.ofAddress(address, scope));
    }

    public TimeSpec aTime() {
        return new TimeSpecImpl(stat.st_atimespec$slice(this.segment));
    }

    public TimeSpec cTime() {
        return new TimeSpecImpl(stat.st_ctimespec$slice(this.segment));
    }

    public TimeSpec mTime() {
        return new TimeSpecImpl(stat.st_mtimespec$slice(this.segment));
    }

    public TimeSpec birthTime() {
        return new TimeSpecImpl(stat.st_birthtimespec$slice(this.segment));
    }

    public void setMode(int mode) {
        stat.st_mode$set(this.segment, (short)mode);
    }

    public int getMode() {
        return stat.st_mode$get(this.segment);
    }

    public void setNLink(short count) {
        stat.st_nlink$set(this.segment, count);
    }

    public long getNLink() {
        return stat.st_nlink$get(this.segment);
    }

    public void setSize(long size) {
        stat.st_size$set(this.segment, size);
    }

    public long getSize() {
        return stat.st_size$get(this.segment);
    }

    public boolean isDir() {
        return (this.getMode() & stat_h.S_IFDIR()) == stat_h.S_IFDIR();
    }

    public void toggleDir(boolean isDir) {
        if (isDir) {
            this.setMode(this.getMode() | stat_h.S_IFDIR());
        } else {
            this.setMode(this.getMode() & ~stat_h.S_IFDIR());
        }
    }

    public boolean isReg() {
        return (this.getMode() & stat_h.S_IFREG()) == stat_h.S_IFREG();
    }

    public void toggleReg(boolean isReg) {
        if (isReg) {
            this.setMode(this.getMode() | stat_h.S_IFREG());
        } else {
            this.setMode(this.getMode() & ~stat_h.S_IFREG());
        }
    }

    public boolean isLnk() {
        return (this.getMode() & stat_h.S_IFLNK()) == stat_h.S_IFLNK();
    }

    public void toggleLnk(boolean isLnk) {
        if (isLnk) {
            this.setMode(this.getMode() | stat_h.S_IFLNK());
        } else {
            this.setMode(this.getMode() & ~stat_h.S_IFLNK());
        }
    }
}

