/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.mac;

import org.cryptomator.jfuse.api.Architecture;
import org.cryptomator.jfuse.api.Errno;
import org.cryptomator.jfuse.api.Fuse;
import org.cryptomator.jfuse.api.FuseBuilder;
import org.cryptomator.jfuse.api.FuseOperations;
import org.cryptomator.jfuse.api.OperatingSystem;
import org.cryptomator.jfuse.api.SupportedPlatform;
import org.cryptomator.jfuse.api.SupportedPlatforms;
import org.cryptomator.jfuse.mac.FuseImpl;
import org.cryptomator.jfuse.mac.MacErrno;

@SupportedPlatforms(value={@SupportedPlatform(os=OperatingSystem.MAC, arch=Architecture.AMD64), @SupportedPlatform(os=OperatingSystem.MAC, arch=Architecture.ARM64)})
public class MacFuseBuilder
implements FuseBuilder {
    private static final Errno ERRNO = new MacErrno();
    private String libraryPath;

    public Errno errno() {
        return ERRNO;
    }

    public void setLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    public Fuse build(FuseOperations fuseOperations) throws UnsatisfiedLinkError {
        if (this.libraryPath != null) {
            System.load(this.libraryPath);
        } else {
            System.loadLibrary("fuse");
        }
        return new FuseImpl(fuseOperations);
    }
}

