/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.macos.revealpath;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.revealpath.RevealFailedException;
import org.cryptomator.integrations.revealpath.RevealPathService;

@Priority(value=100)
@OperatingSystem(value=OperatingSystem.Value.MAC)
public class OpenCmdRevealPathService
implements RevealPathService {
    public void reveal(Path p) throws RevealFailedException {
        try {
            BasicFileAttributes attrs = Files.readAttributes(p, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command("open", attrs.isDirectory() ? "" : "-R", p.toString());
            Process process = pb.start();
            try (BufferedReader reader = process.errorReader();){
                if (process.waitFor(5000L, TimeUnit.MILLISECONDS)) {
                    int exitValue = process.exitValue();
                    if (process.exitValue() != 0) {
                        String error = reader.lines().collect(Collectors.joining());
                        throw new RevealFailedException("open command exited with value " + exitValue + " and error message: " + error);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RevealFailedException((Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RevealFailedException((Exception)e);
        }
    }

    public boolean isSupported() {
        return true;
    }
}

