/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.macos.keychain;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.macos.common.NativeLibLoader;

class MacKeychain {
    private static final int OSSTATUS_SUCCESS = 0;
    private static final int OSSTATUS_NOT_FOUND = -25300;

    MacKeychain() {
    }

    public void storePassword(String serviceName, String account, CharSequence password) throws KeychainAccessException {
        ByteBuffer pwBuf = StandardCharsets.UTF_8.encode(CharBuffer.wrap(password));
        byte[] pwBytes = new byte[pwBuf.remaining()];
        pwBuf.get(pwBytes);
        int errorCode = Native.INSTANCE.storePassword(serviceName.getBytes(StandardCharsets.UTF_8), account.getBytes(StandardCharsets.UTF_8), pwBytes);
        Arrays.fill(pwBytes, (byte)0);
        Arrays.fill(pwBuf.array(), (byte)0);
        if (errorCode != 0) {
            throw new KeychainAccessException("Failed to store password. Error code " + errorCode);
        }
    }

    public char[] loadPassword(String serviceName, String account) {
        byte[] pwBytes = Native.INSTANCE.loadPassword(serviceName.getBytes(StandardCharsets.UTF_8), account.getBytes(StandardCharsets.UTF_8));
        if (pwBytes == null) {
            if ("Cryptomator".equals(serviceName) && this.tryMigratePassword(account)) {
                return this.loadPassword(serviceName, account);
            }
            return null;
        }
        CharBuffer pwBuf = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(pwBytes));
        char[] pw = new char[pwBuf.remaining()];
        pwBuf.get(pw);
        Arrays.fill(pwBytes, (byte)0);
        Arrays.fill(pwBuf.array(), '\u0000');
        return pw;
    }

    private boolean tryMigratePassword(String account) {
        byte[] oldServiceName = new byte[]{67, 114, 121, 112, 116, 111, 109, 97, 116, 111, 114, 0};
        byte[] newServiceName = new byte[]{67, 114, 121, 112, 116, 111, 109, 97, 116, 111, 114};
        byte[] pwBytes = Native.INSTANCE.loadPassword(oldServiceName, account.getBytes(StandardCharsets.UTF_8));
        if (pwBytes == null) {
            return false;
        }
        int errorCode = Native.INSTANCE.storePassword(newServiceName, account.getBytes(StandardCharsets.UTF_8), pwBytes);
        Arrays.fill(pwBytes, (byte)0);
        if (errorCode != 0) {
            return false;
        }
        Native.INSTANCE.deletePassword(oldServiceName, account.getBytes(StandardCharsets.UTF_8));
        return true;
    }

    public boolean deletePassword(String serviceName, String account) throws KeychainAccessException {
        int errorCode = Native.INSTANCE.deletePassword(serviceName.getBytes(StandardCharsets.UTF_8), account.getBytes(StandardCharsets.UTF_8));
        if (errorCode == 0) {
            return true;
        }
        if (errorCode == -25300) {
            return false;
        }
        throw new KeychainAccessException("Failed to delete password. Error code " + errorCode);
    }

    private static class Native {
        static final Native INSTANCE = new Native();

        private Native() {
            NativeLibLoader.loadLib();
        }

        public native int storePassword(byte[] var1, byte[] var2, byte[] var3);

        public native byte[] loadPassword(byte[] var1, byte[] var2);

        public native int deletePassword(byte[] var1, byte[] var2);
    }
}

