/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.macos.keychain;

import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;
import org.cryptomator.macos.common.Localization;
import org.cryptomator.macos.keychain.MacKeychain;

@Priority(value=1000)
@OperatingSystem(value=OperatingSystem.Value.MAC)
public class MacSystemKeychainAccess
implements KeychainAccessProvider {
    private static final String SERVICE_NAME = System.getProperty("cryptomator.integrationsMac.keychainServiceName", "Cryptomator");
    private final MacKeychain keychain;

    public MacSystemKeychainAccess() {
        this(new MacKeychain());
    }

    MacSystemKeychainAccess(MacKeychain keychain) {
        this.keychain = keychain;
    }

    public String displayName() {
        return Localization.get().getString("org.cryptomator.macos.keychain.displayName");
    }

    public void storePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        this.keychain.storePassword(SERVICE_NAME, key, passphrase);
    }

    public char[] loadPassphrase(String key) {
        return this.keychain.loadPassword(SERVICE_NAME, key);
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isLocked() {
        return false;
    }

    public void deletePassphrase(String key) throws KeychainAccessException {
        this.keychain.deletePassword(SERVICE_NAME, key);
    }

    public void changePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        if (this.keychain.deletePassword(SERVICE_NAME, key)) {
            this.keychain.storePassword(SERVICE_NAME, key, passphrase);
        }
    }
}

