/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.macos.keychain;

import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;
import org.cryptomator.macos.common.Localization;
import org.cryptomator.macos.keychain.MacKeychain;

@Priority(value=1000)
@OperatingSystem(value=OperatingSystem.Value.MAC)
public class MacSystemKeychainAccess
implements KeychainAccessProvider {
    private final MacKeychain keychain;

    public MacSystemKeychainAccess() {
        this(new MacKeychain());
    }

    MacSystemKeychainAccess(MacKeychain keychain) {
        this.keychain = keychain;
    }

    public String displayName() {
        return Localization.get().getString("org.cryptomator.macos.keychain.displayName");
    }

    @Deprecated
    public void storePassphrase(String key, CharSequence passphrase) throws KeychainAccessException {
        this.storePassphrase(key, null, passphrase);
    }

    public void storePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        this.keychain.storePassword(key, passphrase);
    }

    public char[] loadPassphrase(String key) {
        return this.keychain.loadPassword(key);
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isLocked() {
        return false;
    }

    public void deletePassphrase(String key) throws KeychainAccessException {
        this.keychain.deletePassword(key);
    }

    @Deprecated
    public void changePassphrase(String key, CharSequence passphrase) throws KeychainAccessException {
        this.changePassphrase(key, null, passphrase);
    }

    public void changePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        if (this.keychain.deletePassword(key)) {
            this.keychain.storePassword(key, passphrase);
        }
    }
}

