/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.macos.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibLoader {
    private static final Logger LOG = LoggerFactory.getLogger(NativeLibLoader.class);
    private static final String LIB = "/libIntegrations.dylib";
    private static volatile boolean loaded = false;

    public static synchronized void loadLib() {
        if (!loaded) {
            try (InputStream dll = NativeLibLoader.class.getResourceAsStream(LIB);){
                Objects.requireNonNull(dll, "Did not find resource /libIntegrations.dylib");
                Path tmpPath = Files.createTempFile("lib", ".dylib", new FileAttribute[0]);
                Files.copy(dll, tmpPath, StandardCopyOption.REPLACE_EXISTING);
                System.load(tmpPath.toString());
                loaded = true;
            }
            catch (NullPointerException e) {
                LOG.error("Did not find resource /libIntegrations.dylib", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("Failed to copy /libIntegrations.dylib to temp dir.", (Throwable)e);
            }
            catch (UnsatisfiedLinkError e) {
                LOG.error("Failed to load lib from /libIntegrations.dylib", (Throwable)e);
            }
        }
    }
}

