/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.macos.uiappearance;

import java.util.HashMap;
import java.util.Map;
import org.cryptomator.integrations.uiappearance.Theme;
import org.cryptomator.integrations.uiappearance.UiAppearanceException;
import org.cryptomator.integrations.uiappearance.UiAppearanceListener;
import org.cryptomator.integrations.uiappearance.UiAppearanceProvider;
import org.cryptomator.macos.uiappearance.AppAppearance;
import org.cryptomator.macos.uiappearance.MacSystemAppearance;

public class MacUiAppearanceProvider
implements UiAppearanceProvider {
    private final MacSystemAppearance systemAppearance = new MacSystemAppearance();
    private final AppAppearance appAppearance = new AppAppearance();
    private final Map<UiAppearanceListener, Long> registeredObservers = new HashMap<UiAppearanceListener, Long>();

    public Theme getSystemTheme() {
        return this.systemAppearance.getCurrentInterfaceStyle().equals("Dark") ? Theme.DARK : Theme.LIGHT;
    }

    public void adjustToTheme(Theme theme) {
        switch (theme) {
            case LIGHT: {
                this.appAppearance.setToAqua();
                break;
            }
            case DARK: {
                this.appAppearance.setToDarkAqua();
            }
        }
    }

    public void addListener(UiAppearanceListener listener) throws UiAppearanceException {
        long observer = this.systemAppearance.registerObserverWithListener(() -> listener.systemAppearanceChanged(this.getSystemTheme()));
        if (observer == 0L) {
            throw new UiAppearanceException("Failed to register system appearance observer.");
        }
        this.registeredObservers.put(listener, observer);
    }

    public void removeListener(UiAppearanceListener listener) throws UiAppearanceException {
        Long observer = this.registeredObservers.remove(listener);
        if (observer != null) {
            this.systemAppearance.deregisterObserver(observer);
        }
    }
}

