/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.macos.keychain;

import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;
import org.cryptomator.macos.keychain.MacKeychain;

public class MacSystemKeychainAccess
implements KeychainAccessProvider {
    private final MacKeychain keychain;

    public MacSystemKeychainAccess() {
        this(new MacKeychain());
    }

    MacSystemKeychainAccess(MacKeychain keychain) {
        this.keychain = keychain;
    }

    public void storePassphrase(String key, CharSequence passphrase) throws KeychainAccessException {
        this.keychain.storePassword(key, passphrase);
    }

    public char[] loadPassphrase(String key) {
        return this.keychain.loadPassword(key);
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isLocked() {
        return false;
    }

    public void deletePassphrase(String key) throws KeychainAccessException {
        this.keychain.deletePassword(key);
    }

    public void changePassphrase(String key, CharSequence passphrase) throws KeychainAccessException {
        if (this.keychain.deletePassword(key)) {
            this.keychain.storePassword(key, passphrase);
        }
    }
}

