/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.mount;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.cli.ParseException;
import org.cryptomator.frontend.dokany.adapter.ReadWriteAdapter;
import org.cryptomator.frontend.dokany.internal.Dokany;
import org.cryptomator.frontend.dokany.internal.DokanyException;
import org.cryptomator.frontend.dokany.internal.DokanyMount;
import org.cryptomator.frontend.dokany.internal.VolumeInformation;
import org.cryptomator.frontend.dokany.internal.constants.DokanOption;
import org.cryptomator.frontend.dokany.internal.constants.FileSystemFeature;
import org.cryptomator.frontend.dokany.internal.structure.DeviceOptions;
import org.cryptomator.frontend.dokany.internal.structure.EnumIntegerSet;
import org.cryptomator.frontend.dokany.locks.LockManager;
import org.cryptomator.frontend.dokany.mount.MountOptionParser;
import org.cryptomator.integrations.mount.Mount;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;
import org.cryptomator.integrations.mount.MountFailedException;
import org.cryptomator.integrations.mount.MountService;
import org.cryptomator.integrations.mount.Mountpoint;
import org.cryptomator.integrations.mount.UnmountFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DokanyMountProvider
implements MountService {
    private static final Logger LOG = LoggerFactory.getLogger(DokanyMountProvider.class);
    private static final int SUPPORTED_DRIVER_VERSION = 400;
    private static final EnumIntegerSet<FileSystemFeature> DEFAULT_FS_FEATURES = new EnumIntegerSet((Enum)FileSystemFeature.CASE_PRESERVED_NAMES, new Enum[]{FileSystemFeature.CASE_SENSITIVE_SEARCH, FileSystemFeature.UNICODE_ON_DISK});

    public String displayName() {
        return "Dokany (1.5)";
    }

    public boolean isSupported() {
        return Dokany.isInstalled() && Dokany.apiVersion() >= (long)DeviceOptions.DOKANY_FEATURE_VERSION && Dokany.driverVersion() >= 400L;
    }

    public String getDefaultMountFlags() {
        return "--options CURRENT_SESSION,ENABLE_FCB_GARBAGE_COLLECTION --thread-count 5 --timeout 10000";
    }

    public Set<MountCapability> capabilities() {
        return Set.of(MountCapability.READ_ONLY, MountCapability.MOUNT_AS_DRIVE_LETTER, MountCapability.MOUNT_TO_EXISTING_DIR, MountCapability.MOUNT_FLAGS, MountCapability.VOLUME_NAME, MountCapability.FILE_SYSTEM_NAME);
    }

    public MountBuilder forFileSystem(Path path) {
        return new DokanyMountBuilder(path);
    }

    static class DokanyMountBuilder
    implements MountBuilder {
        private final Path fsRoot;
        private String fsName = "DOKANY";
        private MountOptionParser.MountOptions mountFlags;
        private Path mountPoint;
        private boolean readOnly = false;
        private String volumeLabel = "DOKANY";

        private DokanyMountBuilder(Path fsRoot) {
            this.fsRoot = fsRoot;
        }

        public MountBuilder setFileSystemName(String fileSystemName) {
            if (this.fsName.length() > 260) {
                throw new IllegalArgumentException("File system name must be at most 260 characters long");
            }
            this.fsName = fileSystemName;
            return this;
        }

        public MountBuilder setMountpoint(Path mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public MountBuilder setMountFlags(String mountFlags) {
            try {
                this.mountFlags = MountOptionParser.parse(mountFlags);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Error parsing mountFlags", e);
            }
            return this;
        }

        public MountBuilder setReadOnly(boolean mountReadOnly) {
            this.readOnly = mountReadOnly;
            return this;
        }

        public MountBuilder setVolumeName(String volumeName) {
            if (volumeName.length() > 260) {
                throw new IllegalArgumentException("Volume label must be at most 260 characters long");
            }
            this.volumeLabel = volumeName;
            return this;
        }

        public Mount mount() throws MountFailedException {
            EnumIntegerSet<DokanOption> adjustedDokanOptions = this.mountFlags.dokanOptions();
            EnumIntegerSet<FileSystemFeature> adjustedFSFeatures = DEFAULT_FS_FEATURES;
            if (this.readOnly) {
                adjustedDokanOptions.add(DokanOption.WRITE_PROTECTION);
                adjustedFSFeatures.add(FileSystemFeature.READ_ONLY_VOLUME);
            }
            DeviceOptions deviceOptions = new DeviceOptions(this.mountPoint.toAbsolutePath().toString(), this.mountFlags.threadCount(), adjustedDokanOptions, "", this.mountFlags.timeout(), this.mountFlags.allocationUnitSize(), this.mountFlags.sectorSize());
            VolumeInformation volumeInfo = new VolumeInformation(255, this.volumeLabel, -1737075662, this.fsName, adjustedFSFeatures);
            AtomicReference<Object> safeUnmountCheck = new AtomicReference<Object>(null);
            ReadWriteAdapter dokanyFs = new ReadWriteAdapter(this.fsRoot, new LockManager(), volumeInfo, safeUnmountCheck);
            DokanyMount mount = new DokanyMount(deviceOptions, dokanyFs, safeUnmountCheck.get());
            LOG.debug("Mounting on {}: ...", (Object)deviceOptions.MountPoint);
            try {
                mount.mount(exception -> {});
                LOG.debug("Mounted directory at {} successfully.", (Object)deviceOptions.MountPoint);
                return new DokanyMountHandle(mount, this.mountPoint);
            }
            catch (DokanyException e) {
                LOG.error("Mounting failed.", (Throwable)e);
                throw new MountFailedException((Exception)e);
            }
        }
    }

    static class DokanyMountHandle
    implements Mount {
        private final DokanyMount mount;
        private final Path mountPoint;

        DokanyMountHandle(DokanyMount mount, Path mountPoint) {
            this.mount = mount;
            this.mountPoint = mountPoint;
        }

        public Mountpoint getMountpoint() {
            return Mountpoint.forPath((Path)this.mountPoint);
        }

        public void unmount() throws UnmountFailedException {
            try {
                this.mount.unmount();
            }
            catch (IllegalStateException e) {
                throw new UnmountFailedException("The file system is still in use.");
            }
        }

        public void unmountForced() throws UnmountFailedException {
            this.mount.unmountForced();
        }

        public void close() throws UnmountFailedException, IOException {
            this.mount.close();
        }
    }
}

