/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.internal.structure.filesecurity;

import java.nio.ByteBuffer;
import org.cryptomator.frontend.dokany.internal.structure.EnumIntegerSet;
import org.cryptomator.frontend.dokany.internal.structure.filesecurity.AccessControlEntry;
import org.cryptomator.frontend.dokany.internal.structure.filesecurity.AccessControlEntryFlag;
import org.cryptomator.frontend.dokany.internal.structure.filesecurity.AccessControlEntryType;
import org.cryptomator.frontend.dokany.internal.structure.filesecurity.AccessMask;
import org.cryptomator.frontend.dokany.internal.structure.filesecurity.SecurityIdentifier;

public class AccessAllowedACE
extends AccessControlEntry {
    EnumIntegerSet<AccessMask> rights;
    SecurityIdentifier sid;

    public AccessAllowedACE(EnumIntegerSet<AccessControlEntryFlag> flags, SecurityIdentifier sid, EnumIntegerSet<AccessMask> rights) {
        super(AccessControlEntryType.ACCESS_ALLOWED_ACE_TYPE, flags);
        this.rights = rights;
        this.sid = sid;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(this.sizeOfByteArray());
        buf.put(this.type.toByteArray());
        buf.put((byte)this.flags.toInt());
        buf.putShort(Short.reverseBytes((short)this.sizeOfByteArray()));
        buf.putInt(Integer.reverseBytes(this.rights.toInt()));
        buf.put(this.sid.toByteArray());
        return buf.array();
    }

    @Override
    public int sizeOfByteArray() {
        return 8 + this.sid.sizeOfByteArray();
    }
}

