/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.internal.structure;

import com.sun.jna.platform.win32.WinBase;
import java.util.Arrays;
import java.util.Objects;
import org.cryptomator.frontend.dokany.internal.constants.FileAttribute;
import org.cryptomator.frontend.dokany.internal.structure.ByHandleFileInfo;
import org.cryptomator.frontend.dokany.internal.structure.EnumIntegerSet;

public class FullFileInfo
extends ByHandleFileInfo {
    private int dwReserved0 = 0;
    private int dwReserved1 = 0;

    public FullFileInfo(String path, long index, EnumIntegerSet<FileAttribute> attributes, int volumeSerialNumber) {
        this(path, index, attributes, volumeSerialNumber, null, null, null);
    }

    public FullFileInfo(String path, long index, EnumIntegerSet<FileAttribute> attributes, int volumeSerialNumber, WinBase.FILETIME creationTime, WinBase.FILETIME lastAccessTime, WinBase.FILETIME lastWriteTime) {
        super(creationTime, lastAccessTime, lastWriteTime);
        this.filePath = Objects.requireNonNull(path);
        this.setIndex(index);
        this.setAttributes(attributes);
        this.dwVolumeSerialNumber = volumeSerialNumber;
    }

    public ByHandleFileInfo toByHandleFileInfo() {
        return this;
    }

    public WinBase.WIN32_FIND_DATA toWin32FindData() {
        char[] cFileName = Arrays.copyOf(this.filePath.toCharArray(), 260);
        if (this.filePath.length() < 260) {
            cFileName[this.filePath.length()] = '\u0000';
        } else {
            cFileName[259] = '\u0000';
        }
        char[] cAlternateFileName = new char[14];
        cAlternateFileName[0] = '\u0000';
        return new WinBase.WIN32_FIND_DATA(this.dwFileAttributes, this.ftCreationTime, this.ftLastAccessTime, this.ftLastWriteTime, this.nFileSizeHigh, this.nFileSizeLow, this.dwReserved0, this.dwReserved1, cFileName, cAlternateFileName);
    }

    @Override
    public String toString() {
        return "FullFileInfo(dwReserved0=" + this.dwReserved0 + ", dwReserved1=" + this.dwReserved1 + ")";
    }
}

