/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.internal.structure;

import java.util.AbstractSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import org.cryptomator.frontend.dokany.internal.constants.EnumInteger;

public final class EnumIntegerSet<T extends Enum<T>>
extends AbstractSet<T> {
    private final EnumSet<T> elements;

    public EnumIntegerSet(Class<T> clazz) {
        this.elements = EnumSet.noneOf(clazz);
    }

    public EnumIntegerSet(T first, T ... others) {
        this.elements = EnumSet.of(first, others);
    }

    @SafeVarargs
    public final void add(T ... items) {
        if (Objects.isNull(items) || items.length < 1) {
            throw new IllegalArgumentException("items array cannot be empty");
        }
        for (T item : items) {
            if (!Objects.nonNull(item)) continue;
            this.elements.add(item);
        }
    }

    public int toInt() {
        int toReturn = 0;
        for (Enum current : this.elements) {
            EnumInteger enumInt = (EnumInteger)((Object)current);
            toReturn |= enumInt.getMask();
        }
        return toReturn;
    }

    @Override
    public boolean add(T e) {
        return this.elements.add(e);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public String toString() {
        return this.elements.toString();
    }
}

