/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.internal.constants;

import org.cryptomator.frontend.dokany.internal.constants.EnumInteger;

public enum SecurityInformation implements EnumInteger
{
    OWNER_SECURITY_INFORMATION(1, "The owner identifier of the object is being referenced"),
    GROUP_SECURITY_INFORMATION(2, "The primary group identifier of the object is being referenced"),
    DACL_SECURITY_INFORMATION(4, "The DACL of the object is being referenced"),
    SACL_SECURITY_INFORMATION(8, "The SACL of the object is being referenced"),
    LABEL_SECURITY_INFORMATION(16, "The mandatory integrity label is being referenced"),
    ATTRIBUTE_SECURITY_INFORMATION(32, "The resource properties of the object being referenced."),
    SCOPE_SECURITY_INFORMATION(64, "The Central Access Policy (CAP) identifier applicable on the object that is being referenced. Each CAP identifier is stored in a SYSTEM_SCOPED_POLICY_ID_ACE type in the SACL of the SD."),
    PROCESS_TRUST_LABEL_SECURITY_INFORMATION(128, "?"),
    ACCESS_FILTER_SECURITY_INFORMATION(256, "?"),
    BACKUP_SECURITY_INFORMATION(65536, "?"),
    PROTECTED_SACL_SECURITY_INFORMATION(0x40000000, "The SACL cannot inherit ACEs"),
    PROTECTED_DACL_SECURITY_INFORMATION(0x40000000, "The DACL cannot inherit access control entries (ACEs)"),
    UNPROTECTED_SACL_SECURITY_INFORMATION(0x10000000, "The SACL inherits ACEs from the parent object. Dokany may not be passing Label ?? 0x00000010"),
    UNPROTECTED_DACL_SECURITY_INFORMATION(0x20000000, "The DACL inherits ACEs from the parent object");

    private final int mask;
    private final String description;

    private SecurityInformation(int mask, String description) {
        this.mask = mask;
        this.description = description;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    public String getDescription() {
        return this.description;
    }
}

