/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.internal.constants;

import org.cryptomator.frontend.dokany.internal.DokanyUtils;
import org.cryptomator.frontend.dokany.internal.constants.EnumInteger;

public enum MountError implements EnumInteger
{
    SUCCESS(0, "Dokan mount succeeded"),
    DOKAN_ERROR(-1, "Dokan mount error"),
    DRIVE_LETTER_ERROR(-2, "Dokan mount failed - Bad drive letter."),
    DRIVER_INSTALL_ERROR(-3, "Dokan mount failed - Cannot install driver."),
    START_ERROR(-4, "Dokan mount failed - Driver answer that something is wrong."),
    MOUNT_ERROR(-5, "Dokan mount failed - Cannot assign a drive letter or mount point. Probably already used by another volume."),
    MOUNT_POINT_ERROR(-6, "Dokan mount failed - Mount point is invalid."),
    VERSION_ERROR(-7, "Dokan mount failed - Requested an incompatible version.");

    private final int mask;
    private final String description;

    public static MountError fromInt(int value) {
        return (MountError)DokanyUtils.enumFromInt((int)value, (EnumInteger[])MountError.values());
    }

    private MountError(int mask, String description) {
        this.mask = mask;
        this.description = description;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    public String getDescription() {
        return this.description;
    }
}

