/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.internal;

import com.sun.jna.platform.win32.WinBase;
import java.util.Date;
import org.cryptomator.frontend.dokany.internal.constants.EnumInteger;
import org.cryptomator.frontend.dokany.internal.structure.EnumIntegerSet;

public class DokanyUtils {
    private DokanyUtils() {
    }

    public static String trimStrToSize(String str, int len) {
        return str.substring(0, Math.min(str.length(), len));
    }

    public static WinBase.FILETIME getTime(Date date) {
        return new WinBase.FILETIME(date);
    }

    public static WinBase.FILETIME getTime(long time) {
        return DokanyUtils.getTime(new Date(time));
    }

    public static WinBase.FILETIME getCurrentTime() {
        return DokanyUtils.getTime(new Date());
    }

    public static <T extends Enum<T>> EnumIntegerSet<T> enumSetFromInt(int value, T[] allEnumValues) {
        EnumIntegerSet<T> elements = new EnumIntegerSet<T>(((Enum)allEnumValues[0]).getDeclaringClass());
        int remainingValues = value;
        for (T current : allEnumValues) {
            int mask = ((EnumInteger)current).getMask();
            if ((remainingValues & mask) != mask) continue;
            elements.add(current);
            remainingValues -= mask;
        }
        return elements;
    }

    public static <T extends EnumInteger> T enumFromInt(int value, T[] enumValues) {
        for (T current : enumValues) {
            if (value != current.getMask()) continue;
            return current;
        }
        throw new IllegalArgumentException("Invalid int value: " + value);
    }
}

