/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.internal;

import com.sun.jna.Callback;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.cryptomator.frontend.dokany.internal.DokanyFileSystem;
import org.cryptomator.frontend.dokany.internal.NativeMethods;
import org.cryptomator.frontend.dokany.internal.constants.NtStatus;
import org.cryptomator.frontend.dokany.internal.constants.Win32ErrorCode;
import org.cryptomator.frontend.dokany.internal.structure.ByHandleFileInfo;
import org.cryptomator.frontend.dokany.internal.structure.DokanyFileInfo;
import org.cryptomator.frontend.dokany.internal.structure.DokanyOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DokanyOperationsProxy
extends DokanyOperations {
    private static final Logger LOG = LoggerFactory.getLogger(DokanyOperationsProxy.class);
    private final CountDownLatch mountSuccessSignaler;
    private final DokanyFileSystem fileSystem;
    private final CallbackThreadInitializer callbackThreadInitializer;
    private final List<Callback> usedCallbacks = new ArrayList<Callback>();

    DokanyOperationsProxy(CountDownLatch mountSuccessSignaler, DokanyFileSystem fileSystem, String nativeThreadNamePrefix) {
        this.mountSuccessSignaler = mountSuccessSignaler;
        this.fileSystem = fileSystem;
        this.callbackThreadInitializer = new DokanCallbackThreadInitializer(nativeThreadNamePrefix);
        this.ZwCreateFile = new ZwCreateFileProxy();
        this.usedCallbacks.add((Callback)this.ZwCreateFile);
        this.CloseFile = fileSystem::closeFile;
        this.usedCallbacks.add((Callback)this.CloseFile);
        this.Cleanup = fileSystem::cleanup;
        this.usedCallbacks.add((Callback)this.Cleanup);
        this.ReadFile = new ReadFileProxy();
        this.usedCallbacks.add((Callback)this.ReadFile);
        this.WriteFile = new WriteFileProxy();
        this.usedCallbacks.add((Callback)this.WriteFile);
        this.FlushFileBuffers = new FlushFileBuffersProxy();
        this.usedCallbacks.add((Callback)this.FlushFileBuffers);
        this.GetFileInformation = new GetFileInformationProxy();
        this.usedCallbacks.add((Callback)this.GetFileInformation);
        this.GetVolumeInformation = new GetVolumeInformationProxy();
        this.usedCallbacks.add((Callback)this.GetVolumeInformation);
        this.GetDiskFreeSpace = new GetDiskFreeSpaceProxy();
        this.usedCallbacks.add((Callback)this.GetDiskFreeSpace);
        this.FindFiles = new FindFilesProxy();
        this.usedCallbacks.add((Callback)this.FindFiles);
        this.FindFilesWithPattern = new FindFilesWithPatternProxy();
        this.usedCallbacks.add((Callback)this.FindFilesWithPattern);
        this.SetFileAttributes = new SetFileAttributesProxy();
        this.usedCallbacks.add((Callback)this.SetFileAttributes);
        this.SetFileTime = new SetFileTimeProxy();
        this.usedCallbacks.add((Callback)this.SetFileTime);
        this.DeleteFile = new DeleteFileProxy();
        this.usedCallbacks.add((Callback)this.DeleteFile);
        this.DeleteDirectory = new DeleteDirectoryProxy();
        this.usedCallbacks.add((Callback)this.DeleteDirectory);
        this.MoveFile = new MoveFileProxy();
        this.usedCallbacks.add((Callback)this.MoveFile);
        this.SetEndOfFile = new SetEndOfFileProxy();
        this.usedCallbacks.add((Callback)this.SetEndOfFile);
        this.SetAllocationSize = new SetAllocationSizeProxy();
        this.usedCallbacks.add((Callback)this.SetAllocationSize);
        this.LockFile = null;
        this.UnlockFile = null;
        this.Mounted = new MountedProxy();
        this.usedCallbacks.add((Callback)this.Mounted);
        this.Unmounted = new UnmountedProxy();
        this.usedCallbacks.add((Callback)this.Unmounted);
        this.GetFileSecurity = (rawPath, rawSecurityInformation, rawSecurityDescriptor, rawSecurityDescriptorLength, rawSecurityDescriptorLengthNeeded, dokanyFileInfo) -> NtStatus.NOT_IMPLEMENTED.getMask();
        this.usedCallbacks.add((Callback)this.GetFileSecurity);
        this.SetFileSecurity = null;
        this.FindStreams = null;
        this.usedCallbacks.forEach(callback -> Native.setCallbackThreadInitializer((Callback)callback, (CallbackThreadInitializer)this.callbackThreadInitializer));
    }

    private static class DokanCallbackThreadInitializer
    extends CallbackThreadInitializer {
        private String prefix;
        private AtomicInteger counter;

        DokanCallbackThreadInitializer(String prefix) {
            super(true, false, prefix, new ThreadGroup(prefix));
            this.prefix = prefix;
            this.counter = new AtomicInteger(0);
        }

        public String getName(Callback cb) {
            return this.prefix + this.counter.getAndIncrement();
        }
    }

    class ZwCreateFileProxy
    implements DokanyOperations.ZwCreateFile {
        ZwCreateFileProxy() {
        }

        @Override
        public long callback(WString rawPath, WinBase.SECURITY_ATTRIBUTES securityContext, int rawDesiredAccess, int rawFileAttributes, int rawShareAccess, int rawCreateDisposition, int rawCreateOptions, DokanyFileInfo dokanyFileInfo) {
            try {
                int win32ErrorCode = DokanyOperationsProxy.this.fileSystem.zwCreateFile(rawPath, securityContext, rawDesiredAccess, rawFileAttributes, rawShareAccess, rawCreateDisposition, rawCreateOptions, dokanyFileInfo);
                if (win32ErrorCode == Win32ErrorCode.ERROR_INVALID_STATE.getMask()) {
                    return NtStatus.FILE_IS_A_DIRECTORY.getMask();
                }
                return NativeMethods.DokanNtStatusFromWin32(win32ErrorCode);
            }
            catch (Exception e) {
                LOG.warn("zwCreateFile(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class ReadFileProxy
    implements DokanyOperations.ReadFile {
        ReadFileProxy() {
        }

        @Override
        public long callback(WString rawPath, Pointer rawBuffer, int rawBufferLength, IntByReference rawReadLength, long rawOffset, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.readFile(rawPath, rawBuffer, rawBufferLength, rawReadLength, rawOffset, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("readFile(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class WriteFileProxy
    implements DokanyOperations.WriteFile {
        WriteFileProxy() {
        }

        @Override
        public long callback(WString rawPath, Pointer rawBuffer, int rawNumberOfBytesToWrite, IntByReference rawNumberOfBytesWritten, long rawOffset, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.writeFile(rawPath, rawBuffer, rawNumberOfBytesToWrite, rawNumberOfBytesWritten, rawOffset, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("writeFile(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class FlushFileBuffersProxy
    implements DokanyOperations.FlushFileBuffers {
        FlushFileBuffersProxy() {
        }

        @Override
        public long callback(WString rawPath, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.flushFileBuffers(rawPath, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("flushFileBuffers(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class GetFileInformationProxy
    implements DokanyOperations.GetFileInformation {
        GetFileInformationProxy() {
        }

        @Override
        public long callback(WString fileName, ByHandleFileInfo handleFileInfo, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.getFileInformation(fileName, handleFileInfo, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("getFileInformation(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class GetVolumeInformationProxy
    implements DokanyOperations.GetVolumeInformation {
        GetVolumeInformationProxy() {
        }

        @Override
        public long callback(Pointer rawVolumeNameBuffer, int rawVolumeNameSize, IntByReference rawVolumeSerialNumber, IntByReference rawMaximumComponentLength, IntByReference rawFileSystemFlags, Pointer rawFileSystemNameBuffer, int rawFileSystemNameSize, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.getVolumeInformation(rawVolumeNameBuffer, rawVolumeNameSize, rawVolumeSerialNumber, rawMaximumComponentLength, rawFileSystemFlags, rawFileSystemNameBuffer, rawFileSystemNameSize, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("getVolumeInformation(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class GetDiskFreeSpaceProxy
    implements DokanyOperations.GetDiskFreeSpace {
        GetDiskFreeSpaceProxy() {
        }

        @Override
        public long callback(LongByReference freeBytesAvailable, LongByReference totalNumberOfBytes, LongByReference totalNumberOfFreeBytes, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.getDiskFreeSpace(freeBytesAvailable, totalNumberOfBytes, totalNumberOfFreeBytes, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("getDiskFreeSpace(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class FindFilesProxy
    implements DokanyOperations.FindFiles {
        FindFilesProxy() {
        }

        @Override
        public long callback(WString rawPath, DokanyOperations.FillWin32FindData rawFillFindData, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.findFiles(rawPath, rawFillFindData, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("findFiles(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class FindFilesWithPatternProxy
    implements DokanyOperations.FindFilesWithPattern {
        FindFilesWithPatternProxy() {
        }

        @Override
        public long callback(WString fileName, WString searchPattern, DokanyOperations.FillWin32FindData rawFillFindData, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.findFilesWithPattern(fileName, searchPattern, rawFillFindData, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("findFilesWithPattern(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class SetFileAttributesProxy
    implements DokanyOperations.SetFileAttributes {
        SetFileAttributesProxy() {
        }

        @Override
        public long callback(WString rawPath, int rawAttributes, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.setFileAttributes(rawPath, rawAttributes, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("setFileAttributes(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class SetFileTimeProxy
    implements DokanyOperations.SetFileTime {
        SetFileTimeProxy() {
        }

        @Override
        public long callback(WString rawPath, WinBase.FILETIME rawCreationTime, WinBase.FILETIME rawLastAccessTime, WinBase.FILETIME rawLastWriteTime, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.setFileTime(rawPath, rawCreationTime, rawLastAccessTime, rawLastWriteTime, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("setFileTime(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class DeleteFileProxy
    implements DokanyOperations.DeleteFile {
        DeleteFileProxy() {
        }

        @Override
        public long callback(WString rawPath, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.deleteFile(rawPath, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("deleteFile(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class DeleteDirectoryProxy
    implements DokanyOperations.DeleteDirectory {
        DeleteDirectoryProxy() {
        }

        @Override
        public long callback(WString rawPath, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.deleteDirectory(rawPath, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("deleteDirectory(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class MoveFileProxy
    implements DokanyOperations.MoveFile {
        MoveFileProxy() {
        }

        @Override
        public long callback(WString rawPath, WString rawNewFileName, boolean rawReplaceIfExisting, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.moveFile(rawPath, rawNewFileName, rawReplaceIfExisting, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("moveFile(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class SetEndOfFileProxy
    implements DokanyOperations.SetEndOfFile {
        SetEndOfFileProxy() {
        }

        @Override
        public long callback(WString rawPath, long rawByteOffset, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.setEndOfFile(rawPath, rawByteOffset, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("setEndOfFile(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class SetAllocationSizeProxy
    implements DokanyOperations.SetAllocationSize {
        SetAllocationSizeProxy() {
        }

        @Override
        public long callback(WString rawPath, long rawLength, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.setAllocationSize(rawPath, rawLength, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("setAllocationSize(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class MountedProxy
    implements DokanyOperations.Mounted {
        MountedProxy() {
        }

        @Override
        public long mounted(DokanyFileInfo dokanyFileInfo) {
            DokanyOperationsProxy.this.mountSuccessSignaler.countDown();
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.mounted(dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("mounted(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class UnmountedProxy
    implements DokanyOperations.Unmounted {
        UnmountedProxy() {
        }

        @Override
        public long unmounted(DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.unmounted(dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("unmounted(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class FindStreamsProxy
    implements DokanyOperations.FindStreams {
        FindStreamsProxy() {
        }

        @Override
        public long callback(WString rawPath, DokanyOperations.FillWin32FindStreamData rawFillFindData, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.findStreams(rawPath, rawFillFindData, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("findStreams(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class SetFileSecurityProxy
    implements DokanyOperations.SetFileSecurity {
        SetFileSecurityProxy() {
        }

        @Override
        public long callback(WString rawPath, int rawSecurityInformation, Pointer rawSecurityDescriptor, int rawSecurityDescriptorLength, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.setFileSecurity(rawPath, rawSecurityInformation, rawSecurityDescriptor, rawSecurityDescriptorLength, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("setFileSecurity(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class GetFileSecurityProxy
    implements DokanyOperations.GetFileSecurity {
        GetFileSecurityProxy() {
        }

        @Override
        public long callback(WString rawPath, int rawSecurityInformation, Pointer rawSecurityDescriptor, int rawSecurityDescriptorLength, IntByReference rawSecurityDescriptorLengthNeeded, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.getFileSecurity(rawPath, rawSecurityInformation, rawSecurityDescriptor, rawSecurityDescriptorLength, rawSecurityDescriptorLengthNeeded, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("getFileSecurity(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class UnlockFileProxy
    implements DokanyOperations.UnlockFile {
        UnlockFileProxy() {
        }

        @Override
        public long callback(WString rawPath, long rawByteOffset, long rawLength, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.unlockFile(rawPath, rawByteOffset, rawLength, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("unlockFile(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }

    class LockFileProxy
    implements DokanyOperations.LockFile {
        LockFileProxy() {
        }

        @Override
        public long callback(WString rawPath, long rawByteOffset, long rawLength, DokanyFileInfo dokanyFileInfo) {
            try {
                return NativeMethods.DokanNtStatusFromWin32(DokanyOperationsProxy.this.fileSystem.lockFile(rawPath, rawByteOffset, rawLength, dokanyFileInfo));
            }
            catch (Exception e) {
                LOG.warn("lockFile(): Uncaught exception. Returning generic failure code.", (Throwable)e);
                return NtStatus.UNSUCCESSFUL.getMask();
            }
        }
    }
}

