/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.adapter;

import com.google.common.base.CharMatcher;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.StreamSupport;
import org.cryptomator.frontend.dokany.adapter.FileUtil;
import org.cryptomator.frontend.dokany.adapter.OpenFile;
import org.cryptomator.frontend.dokany.adapter.OpenHandle;
import org.cryptomator.frontend.dokany.adapter.OpenHandleFactory;
import org.cryptomator.frontend.dokany.internal.DokanyFileSystem;
import org.cryptomator.frontend.dokany.internal.DokanyUtils;
import org.cryptomator.frontend.dokany.internal.NativeMethods;
import org.cryptomator.frontend.dokany.internal.VolumeInformation;
import org.cryptomator.frontend.dokany.internal.constants.AccessMask;
import org.cryptomator.frontend.dokany.internal.constants.CreateOptions;
import org.cryptomator.frontend.dokany.internal.constants.CreationDisposition;
import org.cryptomator.frontend.dokany.internal.constants.FileAccessMask;
import org.cryptomator.frontend.dokany.internal.constants.Win32ErrorCode;
import org.cryptomator.frontend.dokany.internal.structure.ByHandleFileInfo;
import org.cryptomator.frontend.dokany.internal.structure.DokanyFileInfo;
import org.cryptomator.frontend.dokany.internal.structure.DokanyOperations;
import org.cryptomator.frontend.dokany.internal.structure.EnumIntegerSet;
import org.cryptomator.frontend.dokany.internal.structure.FullFileInfo;
import org.cryptomator.frontend.dokany.locks.DataLock;
import org.cryptomator.frontend.dokany.locks.LockManager;
import org.cryptomator.frontend.dokany.locks.PathLock;
import org.cryptomator.frontend.dokany.mount.SafeUnmountCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWriteAdapter
implements DokanyFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(ReadWriteAdapter.class);
    private static final WString MATCH_ALL_PATTERN = new WString("*");
    private final Path root;
    private final LockManager lockManager;
    private final VolumeInformation volumeInformation;
    private final OpenHandleFactory fac;
    private final FileStore fileStore;

    public ReadWriteAdapter(Path root, LockManager lockManager, VolumeInformation volumeInformation) {
        this.root = root;
        this.lockManager = lockManager;
        this.volumeInformation = volumeInformation;
        this.fac = new OpenHandleFactory();
        try {
            this.fileStore = Files.getFileStore(root);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ReadWriteAdapter(Path fileSystemRoot, LockManager lockManager, VolumeInformation volumeInfo, AtomicReference<SafeUnmountCheck> safeUnmountCheck) {
        this.root = fileSystemRoot;
        this.lockManager = lockManager;
        this.volumeInformation = volumeInfo;
        this.fac = new OpenHandleFactory();
        try {
            this.fileStore = Files.getFileStore(this.root);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        safeUnmountCheck.set(this.fac::areNoHandlesOpen);
    }

    @Override
    public int zwCreateFile(WString rawPath, WinBase.SECURITY_ATTRIBUTES securityContext, int rawDesiredAccess, int rawFileAttributes, int rawShareAccess, int rawCreateDisposition, int rawCreateOptions, DokanyFileInfo dokanyFileInfo) {
        Optional<Object> attr;
        Path path;
        try {
            path = this.getRootedPath(rawPath);
        }
        catch (InvalidPathException e) {
            return Win32ErrorCode.ERROR_BAD_PATHNAME.getMask();
        }
        int rawCreationDispostion = FileUtil.convertCreateDispositionToCreationDispostion(rawCreateDisposition);
        int rawDesiredAccessWin32 = FileUtil.mapFileGenericAccessToGenericAccess(rawDesiredAccess);
        EnumIntegerSet createOptions = DokanyUtils.enumSetFromInt((int)rawCreateOptions, (Enum[])CreateOptions.values());
        EnumIntegerSet accessMasks = DokanyUtils.enumSetFromInt((int)rawDesiredAccessWin32, (Enum[])AccessMask.values());
        EnumIntegerSet fileAccessMasks = DokanyUtils.enumSetFromInt((int)rawDesiredAccessWin32, (Enum[])FileAccessMask.values());
        EnumIntegerSet fileAttributes = DokanyUtils.enumSetFromInt((int)rawFileAttributes, (Enum[])org.cryptomator.frontend.dokany.internal.constants.FileAttribute.values());
        CreationDisposition creationDisposition = CreationDisposition.fromInt(rawCreationDispostion);
        LOG.trace("zwCreateFile() is called for {} with the following parameters:\n\tCreateDisposition -- {}\n\tcreateOptions -- {}\n\taccessMasks -- {}\n\tfileAccessMasks -- {}\n\tfileAttributes -- {}.", new Object[]{path, creationDisposition, createOptions, accessMasks, fileAttributes, fileAttributes});
        try {
            attr = Optional.of(Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS));
        }
        catch (NoSuchFileException e) {
            attr = Optional.empty();
        }
        catch (IOException e) {
            return Win32ErrorCode.ERROR_IO_DEVICE.getMask();
        }
        if (attr.isPresent() && ((BasicFileAttributes)attr.get()).isDirectory()) {
            if (!createOptions.contains(CreateOptions.FILE_NON_DIRECTORY_FILE)) {
                dokanyFileInfo.IsDirectory = 1;
            } else {
                LOG.debug("Resource {} is a Directory and cannot be opened as a file.", (Object)path);
                return Win32ErrorCode.ERROR_INVALID_STATE.getMask();
            }
        }
        try (PathLock pathLock = this.lockManager.createPathLock(path.toString()).forWriting();){
            DataLock dataLock;
            block24: {
                dataLock = pathLock.lockDataForWriting();
                try {
                    if (!dokanyFileInfo.isDirectory()) break block24;
                    int n = this.createDirectory(path, creationDisposition, rawFileAttributes, dokanyFileInfo);
                    if (dataLock != null) {
                        dataLock.close();
                    }
                    return n;
                }
                catch (Throwable throwable) {
                    if (dataLock != null) {
                        try {
                            dataLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            Set<OpenOption> openOptions = FileUtil.buildOpenOptions(accessMasks, fileAccessMasks, fileAttributes, createOptions, creationDisposition, dokanyFileInfo.writeToEndOfFile(), attr.isPresent());
            int n = this.createFile(path, creationDisposition, openOptions, rawFileAttributes, dokanyFileInfo);
            if (dataLock != null) {
                dataLock.close();
            }
            return n;
        }
    }

    private int createDirectory(Path path, CreationDisposition creationDisposition, int rawFileAttributes, DokanyFileInfo dokanyFileInfo) {
        LOG.trace("Try to open {} as Directory.", (Object)path);
        int mask = creationDisposition.getMask();
        if (mask == CreationDisposition.CREATE_NEW.getMask() || mask == CreationDisposition.OPEN_ALWAYS.getMask()) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
                LOG.trace("Directory {} successful created ", (Object)path);
            }
            catch (FileAlreadyExistsException e) {
                if (mask == CreationDisposition.CREATE_NEW.getMask()) {
                    LOG.trace("Directory {} already exists.", (Object)path);
                    return Win32ErrorCode.ERROR_ALREADY_EXISTS.getMask();
                }
            }
            catch (FileSystemException e) {
                String reason = e.getReason().toLowerCase();
                if (reason.contains("too long")) {
                    LOG.debug("zwCreateFile(): Creation of {} failed, file name too long.", (Object)path);
                    return Win32ErrorCode.ERROR_FILENAME_EXCED_RANGE.getMask();
                }
                LOG.warn("zwCreateFile(): File system reported an exception during the creation of {}.\n{}", (Object)path, (Object)e);
                return Win32ErrorCode.ERROR_CANNOT_MAKE.getMask();
            }
            catch (IOException e) {
                LOG.warn("zwCreateFile(): IO error occured during the creation of {}.\n{}", (Object)path, (Object)e);
                return Win32ErrorCode.ERROR_CANNOT_MAKE.getMask();
            }
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            LOG.trace("Attempt to open file {} as a directory.", (Object)path);
            return Win32ErrorCode.ERROR_DIRECTORY.getMask();
        }
        try {
            this.setFileAttributes(path, rawFileAttributes);
            dokanyFileInfo.Context = this.fac.openDir(path);
            LOG.trace("({}) {} opened successful with handle {}.", new Object[]{dokanyFileInfo.Context, path, dokanyFileInfo.Context});
        }
        catch (NoSuchFileException e) {
            LOG.trace("{} not found.", (Object)path);
            return Win32ErrorCode.ERROR_PATH_NOT_FOUND.getMask();
        }
        catch (IOException e) {
            LOG.warn("zwCreateFile(): IO error occurred during opening handle to {}.\n{}", (Object)path, (Object)e);
            return Win32ErrorCode.ERROR_OPEN_FAILED.getMask();
        }
        return Win32ErrorCode.ERROR_SUCCESS.getMask();
    }

    private int createFile(Path path, CreationDisposition creationDisposition, Set<OpenOption> openOptions, int rawFileAttributes, DokanyFileInfo dokanyFileInfo) {
        LOG.trace("Try to open {} as File.", (Object)path);
        int mask = creationDisposition.getMask();
        DosFileAttributes attr = null;
        try {
            attr = Files.readAttributes(path, DosFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            LOG.trace("Could not read file attributes.");
        }
        if (attr != null && (mask == CreationDisposition.TRUNCATE_EXISTING.getMask() || mask == CreationDisposition.CREATE_ALWAYS.getMask()) && ((rawFileAttributes & org.cryptomator.frontend.dokany.internal.constants.FileAttribute.HIDDEN.getMask()) == 0 && attr.isHidden() || (rawFileAttributes & org.cryptomator.frontend.dokany.internal.constants.FileAttribute.SYSTEM.getMask()) == 0 && attr.isSystem())) {
            LOG.trace("{} is hidden or system file. Unable to overwrite.", (Object)path);
            return Win32ErrorCode.ERROR_ACCESS_DENIED.getMask();
        }
        if ((attr != null && attr.isReadOnly() || (rawFileAttributes & org.cryptomator.frontend.dokany.internal.constants.FileAttribute.READONLY.getMask()) != 0) && dokanyFileInfo.DeleteOnClose != 0) {
            LOG.trace("{} is readonly. Unable to overwrite.", (Object)path);
            return Win32ErrorCode.ERROR_FILE_READ_ONLY.getMask();
        }
        try {
            dokanyFileInfo.Context = this.fac.openFile(path, openOptions, new FileAttribute[0]);
            if (attr == null || mask == CreationDisposition.TRUNCATE_EXISTING.getMask() || mask == CreationDisposition.CREATE_ALWAYS.getMask()) {
                this.setFileAttributes(path, rawFileAttributes);
            }
            LOG.trace("({}) {} opened successful with handle {}.", new Object[]{dokanyFileInfo.Context, path, dokanyFileInfo.Context});
            if (attr != null && (mask == CreationDisposition.OPEN_ALWAYS.getMask() || mask == CreationDisposition.CREATE_ALWAYS.getMask())) {
                return Win32ErrorCode.ERROR_ALREADY_EXISTS.getMask();
            }
            return Win32ErrorCode.ERROR_SUCCESS.getMask();
        }
        catch (FileAlreadyExistsException e) {
            LOG.trace("File {} already exists.", (Object)path);
            return Win32ErrorCode.ERROR_FILE_EXISTS.getMask();
        }
        catch (NoSuchFileException e) {
            LOG.trace("File {} not found.", (Object)path);
            return Win32ErrorCode.ERROR_FILE_NOT_FOUND.getMask();
        }
        catch (AccessDeniedException e) {
            LOG.trace("zwCreateFile(): Access to file {} was denied.", (Object)path);
            return Win32ErrorCode.ERROR_ACCESS_DENIED.getMask();
        }
        catch (FileSystemException e) {
            String reason = e.getReason().toLowerCase();
            if (reason.contains("too long")) {
                LOG.debug("zwCreateFile(): Creation of {} failed, file name too long.", (Object)path);
                return Win32ErrorCode.ERROR_FILENAME_EXCED_RANGE.getMask();
            }
            LOG.warn("zwCreateFile(): File system reported a problem during the creation of {}.\n{}", (Object)path, (Object)e);
            return Win32ErrorCode.ERROR_CANNOT_MAKE.getMask();
        }
        catch (IOException e) {
            if (attr != null) {
                LOG.warn("zwCreateFile(): IO error occurred during opening handle to {}.\n{}", (Object)path, (Object)e);
                return Win32ErrorCode.ERROR_OPEN_FAILED.getMask();
            }
            LOG.warn("zwCreateFile(): IO error occurred during creation of {}.\n{}", (Object)path, (Object)e);
            return Win32ErrorCode.ERROR_CANNOT_MAKE.getMask();
        }
    }

    @Override
    public void cleanup(WString rawPath, DokanyFileInfo dokanyFileInfo) {
        block19: {
            Path path = this.getRootedPath(rawPath);
            LOG.trace("({}) cleanup() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
            if (dokanyFileInfo.Context == 0L) {
                LOG.debug("cleanup(): Invalid handle to {}.", (Object)path);
            } else {
                try {
                    this.fac.close(dokanyFileInfo.Context);
                    if (!dokanyFileInfo.deleteOnClose()) break block19;
                    try (PathLock pathLock = this.lockManager.createPathLock(path.toString()).forWriting();
                         DataLock dataLock = pathLock.lockDataForWriting();){
                        Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]).setReadOnly(false);
                        Files.delete(path);
                        LOG.trace("({}) {} successful deleted.", (Object)dokanyFileInfo.Context, (Object)path);
                    }
                    catch (DirectoryNotEmptyException e) {
                        LOG.trace("({}) Directory {} not empty.", (Object)dokanyFileInfo.Context, (Object)path);
                    }
                    catch (IOException e) {
                        LOG.warn("({}) cleanup(): IO error during deletion of {}.", new Object[]{dokanyFileInfo.Context, path, e});
                    }
                }
                catch (IOException e) {
                    LOG.warn("({}) cleanup(): Unable to close handle to {}.", new Object[]{dokanyFileInfo.Context, path, e});
                }
            }
        }
    }

    @Override
    public void closeFile(WString rawPath, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.trace("({}) closeFile() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
        if (this.fac.exists(dokanyFileInfo.Context)) {
            LOG.debug("({}) Resource {} was not cleanuped. Closing handle now.", (Object)dokanyFileInfo.Context, (Object)path);
            try {
                this.fac.close(dokanyFileInfo.Context);
            }
            catch (IOException e) {
                LOG.warn("({}) closeFile(): Unable to close handle to resource {}. To close it please restart the adapter.\n{}", new Object[]{dokanyFileInfo.Context, path, e});
            }
        }
        dokanyFileInfo.Context = 0L;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int readFile(WString rawPath, Pointer rawBuffer, int rawBufferLength, IntByReference rawReadLength, long rawOffset, DokanyFileInfo dokanyFileInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 27[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int writeFile(WString rawPath, Pointer rawBuffer, int rawNumberOfBytesToWrite, IntByReference rawNumberOfBytesWritten, long rawOffset, DokanyFileInfo dokanyFileInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 27[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int flushFileBuffers(WString rawPath, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.trace("({}) flushFileBuffers() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
        if (dokanyFileInfo.Context == 0L) {
            LOG.debug("flushFileBuffers(): Invalid handle to {}.", (Object)path);
            return Win32ErrorCode.ERROR_INVALID_HANDLE.getMask();
        }
        if (dokanyFileInfo.isDirectory()) {
            LOG.trace("({}) {} is a directory. Unable to write data to it.", (Object)dokanyFileInfo.Context, (Object)path);
            return Win32ErrorCode.ERROR_ACCESS_DENIED.getMask();
        }
        OpenHandle handle = this.fac.get(dokanyFileInfo.Context);
        try {
            ((OpenFile)handle).flush();
            LOG.trace("Flushed successful to {} with handle {}.", (Object)path, (Object)dokanyFileInfo.Context);
            return Win32ErrorCode.ERROR_SUCCESS.getMask();
        }
        catch (IOException e) {
            LOG.warn("({}) flushFileBuffers(): IO Error while flushing to {}.\n{}", new Object[]{dokanyFileInfo.Context, path, e});
            return Win32ErrorCode.ERROR_WRITE_FAULT.getMask();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getFileInformation(WString fileName, ByHandleFileInfo handleFileInfo, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(fileName);
        LOG.trace("({}) getFileInformation() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
        if (dokanyFileInfo.Context == 0L) {
            LOG.debug("getFileInformation(): Invalid handle to {}.", (Object)path);
            return Win32ErrorCode.ERROR_INVALID_HANDLE.getMask();
        }
        try (PathLock pathLock = this.lockManager.createPathLock(path.toString()).forReading();){
            DataLock dataLock = pathLock.lockDataForReading();
            try {
                DosFileAttributes attr = Files.readAttributes(path, DosFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                FullFileInfo data = this.toFullFileInfo(path, attr);
                data.copyTo(handleFileInfo);
                LOG.trace("({}) File Information successful read from {}.", (Object)dokanyFileInfo.Context, (Object)path);
                int n = Win32ErrorCode.ERROR_SUCCESS.getMask();
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            LOG.trace("({}) Resource {} not found.", (Object)dokanyFileInfo.Context, (Object)path);
            return Win32ErrorCode.ERROR_FILE_NOT_FOUND.getMask();
        }
        catch (IOException e) {
            LOG.warn("({}) getFileInformation(): IO error occurred reading meta data from {}.\n{}", new Object[]{dokanyFileInfo.Context, path, e});
            return Win32ErrorCode.ERROR_READ_FAULT.getMask();
        }
    }

    private FullFileInfo toFullFileInfo(Path path, DosFileAttributes attr) {
        Path filename;
        long index = 0L;
        if (attr.fileKey() != null) {
            index = (Long)attr.fileKey();
        }
        FullFileInfo data = new FullFileInfo((filename = path.getFileName()) != null ? filename.toString() : "", index, FileUtil.dosAttributesToEnumIntegerSet(attr), -1737075662, DokanyUtils.getTime(attr.creationTime().toMillis()), DokanyUtils.getTime(attr.lastAccessTime().toMillis()), DokanyUtils.getTime(attr.lastModifiedTime().toMillis()));
        data.setSize(attr.size());
        return data;
    }

    @Override
    public int findFiles(WString rawPath, DokanyOperations.FillWin32FindData rawFillFindData, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        assert (path.isAbsolute());
        LOG.trace("({}) findFiles() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
        return this.findFilesWithPattern(rawPath, MATCH_ALL_PATTERN, rawFillFindData, dokanyFileInfo);
    }

    @Override
    public int findFilesWithPattern(WString fileName, WString searchPattern, DokanyOperations.FillWin32FindData rawFillFindData, DokanyFileInfo dokanyFileInfo) {
        int n;
        block10: {
            Path path = this.getRootedPath(fileName);
            assert (path.isAbsolute());
            LOG.trace("({}) findFilesWithPattern() is called for {} with search pattern {}.", new Object[]{dokanyFileInfo.Context, path, searchPattern.toString()});
            if (dokanyFileInfo.Context == 0L) {
                LOG.debug("findFilesWithPattern(): Invalid handle to {}.", (Object)path);
                return Win32ErrorCode.ERROR_INVALID_HANDLE.getMask();
            }
            DirectoryStream.Filter<Path> filter = searchPattern.equals((Object)MATCH_ALL_PATTERN) ? p -> true : p -> NativeMethods.DokanIsNameInExpression(searchPattern, new WString(p.getFileName().toString()), true);
            DirectoryStream<Path> ds = Files.newDirectoryStream(path, filter);
            try {
                Spliterator<Path> spliterator = Spliterators.spliteratorUnknownSize(ds.iterator(), 1);
                StreamSupport.stream(spliterator, false).map(p -> {
                    assert (p.isAbsolute());
                    try {
                        DosFileAttributes attr = Files.readAttributes(p, DosFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                        if (!attr.isSymbolicLink()) {
                            return this.toFullFileInfo((Path)p, attr).toWin32FindData();
                        }
                        LOG.warn("({}) findFilesWithPattern(): {} is a symlink, which is not supported by Dokan. Will be ignored in file listing.", (Object)dokanyFileInfo.Context, p);
                        return null;
                    }
                    catch (IOException e) {
                        LOG.warn("({}) findFilesWithPattern(): IO error accessing {}. Will be ignored in file listing. Reported Exception:", new Object[]{dokanyFileInfo.Context, p, e});
                        return null;
                    }
                }).filter(Objects::nonNull).forEach(file -> {
                    assert (file != null);
                    LOG.trace("({}) findFilesWithPattern(): found file {}", (Object)dokanyFileInfo.Context, (Object)file.getFileName());
                    rawFillFindData.fillWin32FindData((WinBase.WIN32_FIND_DATA)file, dokanyFileInfo);
                });
                LOG.trace("({}) Successful searched content in {}.", (Object)dokanyFileInfo.Context, (Object)path);
                n = Win32ErrorCode.ERROR_SUCCESS.getMask();
                if (ds == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ds != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("({}) findFilesWithPattern(): Unable to list content of directory {}.", new Object[]{dokanyFileInfo.Context, path, e});
                    return Win32ErrorCode.ERROR_READ_FAULT.getMask();
                }
            }
            ds.close();
        }
        return n;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setFileAttributes(WString rawPath, int rawAttributes, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.trace("({}) setFileAttributes() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
        if (dokanyFileInfo.Context == 0L) {
            LOG.debug("setFileAttribute(): Invalid handle to {}.", (Object)path);
            return Win32ErrorCode.ERROR_INVALID_HANDLE.getMask();
        }
        try (PathLock pathLock = this.lockManager.createPathLock(path.toString()).forReading();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                this.setFileAttributes(path, rawAttributes);
                int n = Win32ErrorCode.ERROR_SUCCESS.getMask();
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            LOG.trace("({}) setFileAttributes(): File {} not found.", (Object)dokanyFileInfo.Context, (Object)path);
            return Win32ErrorCode.ERROR_FILE_NOT_FOUND.getMask();
        }
        catch (IOException e) {
            LOG.warn("({}) setFileAttributes(): IOException occurred during operation on {}.\n{}", new Object[]{dokanyFileInfo.Context, path, e});
            return Win32ErrorCode.ERROR_WRITE_FAULT.getMask();
        }
    }

    private void setFileAttributes(Path path, int rawAttributes) throws IOException {
        block5: {
            DosFileAttributeView attrView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            EnumIntegerSet attrsToUnset = DokanyUtils.enumSetFromInt((int)Integer.MAX_VALUE, (Enum[])FileUtil.supportedAttributeValuesToSet);
            EnumIntegerSet attrsToSet = DokanyUtils.enumSetFromInt((int)rawAttributes, (Enum[])org.cryptomator.frontend.dokany.internal.constants.FileAttribute.values());
            if (rawAttributes == 0) break block5;
            if ((rawAttributes & org.cryptomator.frontend.dokany.internal.constants.FileAttribute.NORMAL.getMask()) != 0 && rawAttributes - org.cryptomator.frontend.dokany.internal.constants.FileAttribute.NORMAL.getMask() == 0) {
                for (org.cryptomator.frontend.dokany.internal.constants.FileAttribute attr : attrsToUnset) {
                    FileUtil.setAttribute(attrView, attr, false);
                }
            } else {
                attrsToSet.remove(org.cryptomator.frontend.dokany.internal.constants.FileAttribute.NORMAL);
                for (org.cryptomator.frontend.dokany.internal.constants.FileAttribute attr : attrsToSet) {
                    FileUtil.setAttribute(attrView, attr, true);
                    attrsToUnset.remove(attr);
                }
                for (org.cryptomator.frontend.dokany.internal.constants.FileAttribute attr : attrsToUnset) {
                    FileUtil.setAttribute(attrView, attr, false);
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setFileTime(WString rawPath, WinBase.FILETIME rawCreationTime, WinBase.FILETIME rawLastAccessTime, WinBase.FILETIME rawLastWriteTime, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.trace("({}) setFileTime() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
        if (dokanyFileInfo.Context == 0L) {
            LOG.debug("setFileTime(): Invalid handle to {}.", (Object)path);
            return Win32ErrorCode.ERROR_INVALID_HANDLE.getMask();
        }
        try (PathLock pathLock = this.lockManager.createPathLock(path.toString()).forReading();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                FileTime lastModifiedTime = FileUtil.toFileTime(rawLastWriteTime).orElse(null);
                FileTime lastAccessTime = FileUtil.toFileTime(rawLastAccessTime).orElse(null);
                FileTime createdTime = FileUtil.toFileTime(rawCreationTime).orElse(null);
                Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).setTimes(lastModifiedTime, lastAccessTime, createdTime);
                LOG.trace("({}) Successful updated Filetime for {} to mTime {}, cTime {} and aTime {}.", new Object[]{dokanyFileInfo.Context, path, lastModifiedTime != null ? Long.valueOf(lastModifiedTime.toMillis()) : null, createdTime != null ? Long.valueOf(createdTime.toMillis()) : null, lastAccessTime != null ? Long.valueOf(lastAccessTime.toMillis()) : null});
                int n = Win32ErrorCode.ERROR_SUCCESS.getMask();
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            LOG.trace("({}) File {} not found.", (Object)dokanyFileInfo.Context, (Object)path);
            return Win32ErrorCode.ERROR_FILE_NOT_FOUND.getMask();
        }
        catch (IOException e) {
            LOG.warn("({}) setFileTime(): IO error occurred accessing {}.\n{}", new Object[]{dokanyFileInfo.Context, path, e});
            return Win32ErrorCode.ERROR_WRITE_FAULT.getMask();
        }
    }

    @Override
    public int deleteFile(WString rawPath, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.trace("({}) deleteFile() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
        if (dokanyFileInfo.Context == 0L) {
            LOG.debug("deleteFile(): Invalid handle to {}.", (Object)path);
            return Win32ErrorCode.ERROR_INVALID_HANDLE.getMask();
        }
        if (dokanyFileInfo.isDirectory()) {
            LOG.trace("({}) {} is a directory. Unable to delete via deleteFile()", (Object)dokanyFileInfo.Context, (Object)path);
            return Win32ErrorCode.ERROR_ACCESS_DENIED.getMask();
        }
        try (PathLock pathLock = this.lockManager.createPathLock(path.toString()).forWriting();){
            DataLock dataLock;
            block21: {
                block22: {
                    dataLock = pathLock.lockDataForWriting();
                    try {
                        OpenHandle handle = this.fac.get(dokanyFileInfo.Context);
                        if (!Files.exists(path, new LinkOption[0])) break block21;
                        if (!((OpenFile)handle).canBeDeleted()) break block22;
                        LOG.trace("({}) Deletion of {} possible.", (Object)dokanyFileInfo.Context, (Object)path);
                        int n = Win32ErrorCode.ERROR_SUCCESS.getMask();
                        if (dataLock != null) {
                            dataLock.close();
                        }
                        return n;
                    }
                    catch (Throwable throwable) {
                        if (dataLock != null) {
                            try {
                                dataLock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                LOG.trace("({}) Deletion of {} not possible.", (Object)dokanyFileInfo.Context, (Object)path);
                int n = Win32ErrorCode.ERROR_BUSY.getMask();
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            LOG.trace("({}) deleteFile(): {} not found.", (Object)dokanyFileInfo.Context, (Object)path);
            int n = Win32ErrorCode.ERROR_FILE_NOT_FOUND.getMask();
            if (dataLock != null) {
                dataLock.close();
            }
            return n;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int deleteDirectory(WString rawPath, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.trace("({}) deleteDirectory() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
        if (dokanyFileInfo.Context == 0L) {
            LOG.debug("deleteDirectory(): Invalid handle to {}.", (Object)path);
            return Win32ErrorCode.ERROR_INVALID_HANDLE.getMask();
        }
        if (!dokanyFileInfo.isDirectory()) {
            LOG.trace("({}) {} is a file. Unable to delete via deleteDirectory()", (Object)dokanyFileInfo.Context, (Object)path);
            return Win32ErrorCode.ERROR_ACCESS_DENIED.getMask();
        }
        try (PathLock pathLock = this.lockManager.createPathLock(path.toString()).forWriting();){
            int n;
            DataLock dataLock;
            block32: {
                DirectoryStream<Path> emptyCheck;
                block30: {
                    int n2;
                    block31: {
                        dataLock = pathLock.lockDataForWriting();
                        emptyCheck = Files.newDirectoryStream(path);
                        if (!emptyCheck.iterator().hasNext()) break block30;
                        LOG.trace("({}) Deletion of {} not possible.", (Object)dokanyFileInfo.Context, (Object)path);
                        n2 = Win32ErrorCode.ERROR_DIR_NOT_EMPTY.getMask();
                        if (emptyCheck == null) break block31;
                        emptyCheck.close();
                    }
                    if (dataLock != null) {
                        dataLock.close();
                    }
                    return n2;
                }
                LOG.trace("({}) Deletion of {} possible.", (Object)dokanyFileInfo.Context, (Object)path);
                n = Win32ErrorCode.ERROR_SUCCESS.getMask();
                if (emptyCheck == null) break block32;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                if (emptyCheck != null) {
                                    try {
                                        emptyCheck.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                LOG.warn("({}) deleteDirectory(): IO error occurred reading {}.\n{}", new Object[]{dokanyFileInfo.Context, path, e});
                                int n3 = Win32ErrorCode.ERROR_CURRENT_DIRECTORY.getMask();
                                if (dataLock != null) {
                                    dataLock.close();
                                }
                                if (pathLock != null) {
                                    pathLock.close();
                                }
                                return n3;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (dataLock != null) {
                                try {
                                    dataLock.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                            }
                            throw throwable3;
                        }
                    }
                }
                emptyCheck.close();
            }
            if (dataLock != null) {
                dataLock.close();
            }
            return n;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int moveFile(WString rawPath, WString rawNewFileName, boolean rawReplaceIfExisting, DokanyFileInfo dokanyFileInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setEndOfFile(WString rawPath, long rawByteOffset, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.trace("({}) setEndOfFile() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
        if (dokanyFileInfo.Context == 0L) {
            LOG.debug("setEndOfFile(): Invalid handle to {}.", (Object)path);
            return Win32ErrorCode.ERROR_INVALID_HANDLE.getMask();
        }
        if (dokanyFileInfo.isDirectory()) {
            LOG.trace("({}) setEndOfFile(): {} is a directory. Unable to truncate.", (Object)dokanyFileInfo.Context, (Object)path);
            return Win32ErrorCode.ERROR_ACCESS_DENIED.getMask();
        }
        try (PathLock pathLock = this.lockManager.createPathLock(path.toString()).forReading();){
            DataLock dataLock = pathLock.lockDataForWriting();
            try {
                OpenHandle handle = this.fac.get(dokanyFileInfo.Context);
                ((OpenFile)handle).truncate(rawByteOffset);
                LOG.trace("({}) Successful truncated {} to size {}.", new Object[]{dokanyFileInfo.Context, path, rawByteOffset});
                int n = Win32ErrorCode.ERROR_SUCCESS.getMask();
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.warn("({}) setEndOfFile(): IO error while truncating {}.\n{}", new Object[]{dokanyFileInfo.Context, path, e});
            return Win32ErrorCode.ERROR_WRITE_FAULT.getMask();
        }
    }

    @Override
    public int setAllocationSize(WString rawPath, long rawLength, DokanyFileInfo dokanyFileInfo) {
        Path path = this.getRootedPath(rawPath);
        LOG.trace("({}) setAllocationSize() is called for {}.", (Object)dokanyFileInfo.Context, (Object)path);
        return this.setEndOfFile(rawPath, rawLength, dokanyFileInfo);
    }

    @Override
    public int lockFile(WString rawPath, long rawByteOffset, long rawLength, DokanyFileInfo dokanyFileInfo) {
        return 0;
    }

    @Override
    public int unlockFile(WString rawPath, long rawByteOffset, long rawLength, DokanyFileInfo dokanyFileInfo) {
        return 0;
    }

    @Override
    public int getDiskFreeSpace(LongByReference freeBytesAvailable, LongByReference totalNumberOfBytes, LongByReference totalNumberOfFreeBytes, DokanyFileInfo dokanyFileInfo) {
        LOG.trace("getFreeDiskSpace() is called.");
        try {
            totalNumberOfBytes.setValue(this.fileStore.getTotalSpace());
            freeBytesAvailable.setValue(this.fileStore.getUsableSpace());
            totalNumberOfFreeBytes.setValue(this.fileStore.getUnallocatedSpace());
            return Win32ErrorCode.ERROR_SUCCESS.getMask();
        }
        catch (IOException e) {
            LOG.warn("({}) getFreeDiskSpace(): Unable to detect disk space status.\n{}", (Object)dokanyFileInfo.Context, (Object)e);
            return Win32ErrorCode.ERROR_READ_FAULT.getMask();
        }
    }

    @Override
    public int getVolumeInformation(Pointer rawVolumeNameBuffer, int rawVolumeNameSize, IntByReference rawVolumeSerialNumber, IntByReference rawMaximumComponentLength, IntByReference rawFileSystemFlags, Pointer rawFileSystemNameBuffer, int rawFileSystemNameSize, DokanyFileInfo dokanyFileInfo) {
        try {
            rawVolumeNameBuffer.setWideString(0L, DokanyUtils.trimStrToSize(this.volumeInformation.name(), rawVolumeNameSize));
            rawVolumeSerialNumber.setValue(this.volumeInformation.serialNumber());
            rawMaximumComponentLength.setValue(this.volumeInformation.maxComponentLength());
            rawFileSystemFlags.setValue(this.volumeInformation.fileSystemFeatures().toInt());
            rawFileSystemNameBuffer.setWideString(0L, DokanyUtils.trimStrToSize(this.volumeInformation.name(), rawFileSystemNameSize));
            return Win32ErrorCode.ERROR_SUCCESS.getMask();
        }
        catch (Throwable t) {
            return Win32ErrorCode.ERROR_READ_FAULT.getMask();
        }
    }

    @Override
    public int mounted(DokanyFileInfo dokanyFileInfo) {
        LOG.trace("mounted() is called.");
        return 0;
    }

    @Override
    public int unmounted(DokanyFileInfo dokanyFileInfo) {
        LOG.trace("unmounted() is called.");
        try {
            this.fac.close();
        }
        catch (IOException e) {
            LOG.warn("Could not close all open handles.", (Throwable)e);
        }
        return 0;
    }

    @Override
    public int getFileSecurity(WString rawPath, int rawSecurityInformation, Pointer rawSecurityDescriptor, int rawSecurityDescriptorLength, IntByReference rawSecurityDescriptorLengthNeeded, DokanyFileInfo dokanyFileInfo) {
        return 0;
    }

    @Override
    public int setFileSecurity(WString rawPath, int rawSecurityInformation, Pointer rawSecurityDescriptor, int rawSecurityDescriptorLength, DokanyFileInfo dokanyFileInfo) {
        return 0;
    }

    @Override
    public void fillWin32FindData(WinBase.WIN32_FIND_DATA rawFillFindData, DokanyFileInfo dokanyFileInfo) {
    }

    @Override
    public int findStreams(WString rawPath, DokanyOperations.FillWin32FindStreamData rawFillFindData, DokanyFileInfo dokanyFileInfo) {
        return 0;
    }

    private Path getRootedPath(WString rawPath) {
        String unixPath = rawPath.toString().replace('\\', '/');
        String relativeUnixPath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)unixPath);
        assert (this.root.isAbsolute());
        return this.root.resolve(relativeUnixPath);
    }
}

