/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.adapter;

import com.google.common.base.MoreObjects;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.cryptomator.frontend.dokany.adapter.OpenHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFile
extends OpenHandle {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFile.class);
    private static final int BUFFER_SIZE = 4096;
    private final FileChannel channel;

    public OpenFile(Path path, FileChannel channel) {
        super(path);
        this.channel = channel;
    }

    public synchronized int read(Pointer buf, int num, long offset) throws IOException {
        int read;
        if (offset >= this.channel.size()) {
            return 0;
        }
        ByteBuffer bb = ByteBuffer.allocate(4096);
        int pos = 0;
        this.channel.position(offset);
        do {
            int remaining;
            if ((read = this.readNext(bb, remaining = num - pos)) == -1) {
                return pos;
            }
            LOG.trace("Reading {}-{} ({}-{})", new Object[]{offset + (long)pos, offset + (long)pos + (long)read, offset, offset + (long)num});
            buf.write((long)pos, bb.array(), 0, read);
        } while ((pos += read) < num);
        return pos;
    }

    public synchronized int write(Pointer buf, int num, long offset) throws IOException {
        int len;
        ByteBuffer bb = ByteBuffer.allocate(4096);
        int written = 0;
        this.channel.position(offset);
        do {
            int remaining = num - written;
            bb.clear();
            len = Math.min(remaining, bb.capacity());
            buf.read((long)written, bb.array(), 0, len);
            bb.limit(len);
            this.channel.write(bb);
        } while ((written += len) < num);
        return written;
    }

    public int append(Pointer buf, int num) throws IOException {
        return this.write(buf, num, this.channel.size());
    }

    private int readNext(ByteBuffer readBuf, long num) throws IOException {
        readBuf.clear();
        readBuf.limit((int)Math.min((long)readBuf.capacity(), num));
        return this.channel.read(readBuf);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public void flush() throws IOException {
        this.channel.force(false);
    }

    public void truncate(long size) throws IOException {
        this.channel.truncate(size);
    }

    public boolean canBeDeleted() {
        boolean bl;
        block9: {
            FileLock lock = this.channel.tryLock();
            try {
                boolean bl2 = bl = lock != null;
                if (lock == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NonWritableChannelException e) {
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
            lock.close();
        }
        return bl;
    }

    public String toString() {
        return MoreObjects.toStringHelper(OpenFile.class).add("path", (Object)this.path).add("channel", (Object)this.channel).toString();
    }

    public static OpenFile open(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        FileChannel channel = FileChannel.open(path, options, attrs);
        return new OpenFile(path, channel);
    }
}

