// Generated by delombok at Thu Apr 12 13:54:15 CEST 2018
package org.cryptomator.frontend.dokany.internal.structure;

import org.cryptomator.frontend.dokany.internal.constants.FileAttribute;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinBase.FILETIME;
import com.sun.jna.platform.win32.WinBase.WIN32_FIND_DATA;

import java.util.Arrays;
import java.util.Objects;

/**
 * Combines {@link FullFileInfo} and {@link WIN32_FIND_DATA}. This object will be stored in the Xodus fileInfo store.
 */
public class FullFileInfo extends ByHandleFileInfo {

	/**
	 * If the dwFileAttributes member includes the FILE_ATTRIBUTE_REPARSE_POINT attribute, this member specifies the reparse point tag. Otherwise, this value is undefined and
	 * should not be used. For more information see Reparse Point Tags.
	 * <p>
	 * IO_REPARSE_TAG_CSV (0x80000009) IO_REPARSE_TAG_DEDUP (0x80000013) IO_REPARSE_TAG_DFS (0x8000000A) IO_REPARSE_TAG_DFSR (0x80000012) IO_REPARSE_TAG_HSM (0xC0000004)
	 * IO_REPARSE_TAG_HSM2 (0x80000006) IO_REPARSE_TAG_MOUNT_POINT (0xA0000003) IO_REPARSE_TAG_NFS (0x80000014) IO_REPARSE_TAG_SIS (0x80000007) IO_REPARSE_TAG_SYMLINK (0xA000000C)
	 * IO_REPARSE_TAG_WIM (0x80000008)
	 */
	private int dwReserved0 = 0;
	/**
	 * Reserved for future use.
	 */
	private int dwReserved1 = 0;

	public FullFileInfo(final String path, final long index, final EnumIntegerSet<FileAttribute> attributes, final int volumeSerialNumber) {
		// times automatically set to now by ByHandleFileInfo constructors
		this(path, index, attributes, volumeSerialNumber, null, null, null);
	}

	public FullFileInfo(final String path, final long index, final EnumIntegerSet<FileAttribute> attributes, final int volumeSerialNumber, final FILETIME creationTime, final FILETIME lastAccessTime, final FILETIME lastWriteTime) {
		super(creationTime, lastAccessTime, lastWriteTime);
		filePath = Objects.requireNonNull(path);
		setIndex(index);
		setAttributes(attributes);
		dwVolumeSerialNumber = volumeSerialNumber;
	}

	/**
	 * Simply casts this object to ByHandleFileInfo
	 *
	 * @return this (cast as ByHandleFileInfo)
	 */

	public ByHandleFileInfo toByHandleFileInfo() {
		return this;
	}

	/**
	 * @return WIN32_FIND_DATA
	 */

	public WIN32_FIND_DATA toWin32FindData() {
		char[] cFileName = Arrays.copyOf(filePath.toCharArray(), WinBase.MAX_PATH);

		//ensure the string is null terminated
		if(filePath.length() < WinBase.MAX_PATH){
			cFileName[filePath.length()] = '\0';
		} else{
			cFileName[WinBase.MAX_PATH-1] = '\0';
		}

		//cannot be used by dokany, see https://github.com/dokan-dev/dokany/issues/301
		final char[] cAlternateFileName = new char[14];
		cAlternateFileName[0] = '\0';

		return new WIN32_FIND_DATA(dwFileAttributes, ftCreationTime, ftLastAccessTime, ftLastWriteTime, nFileSizeHigh, nFileSizeLow, dwReserved0, dwReserved1, cFileName, cAlternateFileName);
	}

	@Override
	@SuppressWarnings("all")
	public String toString() {
		return "FullFileInfo(dwReserved0=" + this.dwReserved0 + ", dwReserved1=" + this.dwReserved1 + ")";
	}
}
