// Generated by delombok at Thu Apr 12 13:54:15 CEST 2018
package org.cryptomator.frontend.dokany.internal.structure;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.cryptomator.frontend.dokany.internal.constants.DokanOption;
import com.sun.jna.Structure;
import com.sun.jna.WString;

/**
 * Dokany mount options used to describe Dokany device behavior. This is the same structure as PDOKAN_OPTIONS (dokan.h) in the C++ version of Dokany.
 */
public class DeviceOptions extends Structure implements Structure.ByReference {

	public static short DOKANY_FEATURE_VERSION = 150;

	/**
	 * Version of the Dokany features requested (version "123" is equal to Dokany version 1.2.3).
	 */
	public short Version = DOKANY_FEATURE_VERSION;
	/**
	 * Number of threads to be used internally by Dokany library. More thread will handle more event at the same time.
	 */
	public short ThreadCount;
	/**
	 * Features enable for the mount.
	 *
	 * @see {@link DokanOption}
	 */
	public int Options;
	private EnumIntegerSet<DokanOption> dokanOptions;
	/**
	 * FileSystem can store anything here
	 */
	public long GlobalContext = 0L;
	/**
	 * Mount point. Can be M:\\ (drive letter) or C:\\mount\\dokany (path in NTFS).
	 */
	public WString MountPoint;
	/**
	 * UNC name used for network volume.
	 */
	public WString UNCName;
	/**
	 * Max timeout in milliseconds of each request before Dokany gives up.
	 */
	public long Timeout;
	/**
	 * Allocation Unit Size of the volume.
	 */
	public long AllocationUnitSize;
	/**
	 * Sector Size of the volume.
	 */
	public long SectorSize;

	public DeviceOptions() {
	}

	public DeviceOptions(final String mountPoint, final short threadCount, final EnumIntegerSet<DokanOption> dokanOptions, final String uncName, final long timeout, final long allocationUnitSize, final long sectorSize) {
		MountPoint = new WString(mountPoint);
		ThreadCount = threadCount;
		this.dokanOptions = dokanOptions;
		Options = dokanOptions.toInt();
		if (Objects.nonNull(uncName)) {
			UNCName = new WString(uncName);
		} else {
			UNCName = null;
		}
		Timeout = timeout;
		AllocationUnitSize = allocationUnitSize;
		SectorSize = sectorSize;
	}

	public EnumIntegerSet<DokanOption> getDokanOptions() {
		return dokanOptions;
	}

	@Override
	protected List<String> getFieldOrder() {
		return Arrays.asList("Version", "ThreadCount", "Options", "GlobalContext", "MountPoint", "UNCName", "Timeout", "AllocationUnitSize", "SectorSize");
	}

	@Override
	@SuppressWarnings("all")
	public String toString() {
		return "DeviceOptions(Version=" + this.Version + ", ThreadCount=" + this.ThreadCount + ", Options=" + this.Options + ", mountOptions=" + this.getDokanOptions() + ", GlobalContext=" + this.GlobalContext + ", MountPoint=" + this.MountPoint + ", UNCName=" + this.UNCName + ", Timeout=" + this.Timeout + ", AllocationUnitSize=" + this.AllocationUnitSize + ", SectorSize=" + this.SectorSize + ")";
	}
}
